// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_CURVE_CONTAINER_)

#define _MTG_CURVE_CONTAINER_



#include "MtgFileName.h"

#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE



class tCurve;

class tCurveInstance;

class tDateBase;

class tEngine;

class tImageInstance;

class tParser;





//

//   t C u r v e C o n t a i n e r

//



class tCurveContainer {



        // A curve container is used for two purposes: by the read-only

        // objects like optimizer, and by the engines. In order not to

        // violate the read-only constraints, the engine copies the

        // curve container before it uses it. (In other scenarios, we

        // do this by creating a T-"instance" of type T. Here, let's just

        // copy the entire thing, it's so small.)



    struct tItem {

        tCurve* m_pCurve;                   // referenced, with

                                            // increment/decrement

        tFileName m_OutFile;                // evt. save (optional)

        tImageInstance* m_pImage;           // if the curve appears...

        int m_nTag;                         // ,,,in an image 

        tCurveInstance* m_pInstance;        // used during evaluation    

        tItem* m_pStealFrom;                // speed up evaluation

        int m_nRefCount;

        double m_gBadWeight;                

    };



    tHeap<tItem*> m_Item;                   // list of references to curves



    void cleanup();

    void copyFrom( const tCurveContainer& Container );



    void addCurve( tCurve* pCurve, const tFileName* pOutFile,

        tImageInstance* pImage, int nTag );



public:



    tCurveContainer();

    tCurveContainer( const tCurveContainer& Container );



    ~tCurveContainer();



    tCurveContainer& operator=( const tCurveContainer& Container );



    void addCurve( tCurve* pCurve, const tFileName* pOutFile = 0 );

    void addCurve( tCurve* pCurve, tImageInstance* pImage, int nTag );



    void merge( const tCurveContainer& Container );



    bool hasCurves() const {

        return m_Item.numOfElems() > 0;

    }



        // Prepare all the curves for evaluation.



    tRetCode prepare( tEngine& Engine );



        // Evaluate all curves for the weight.



    tRetCode evaluate( double gWeight );



        // Finalize all curves after evaluation (maybe repeatedly).



    tRetCode postProcess( double gWeight = -1 );



        // Propagate results to images:



    tRetCode propagate();



        // Save all curves in whatever form they support.

        // (Does not affect the images.)



    tRetCode save() const;



    tRetCode parse( tParser& Parser );

};



MTG_END_NAMESPACE



#endif

