// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_CURVE_INSTANCE_)

#define _MTG_CURVE_INSTANCE_



#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE



class tDateBase;

class tCurve;

class tEngine;





//

//   t C u r v e I n s t a n c e

//



class tCurveInstance {



        // The translation factors for SI conversion.



    double m_gAlpha;

    double m_gBeta;



        // What samples are valid?



    int m_nFirstSample;

    int m_nLastSample;



        // Curve instances cannot be copied; they exist only

        // for a unique curve generation.



    tCurveInstance( const tCurveInstance& CI, tEngine& ES )

        : m_Curve( CI.m_Curve ), m_Engine( ES ) {

        throw tException( INTERNAL_ERROR );

    }



protected:



        // The curve which created the instance:

        

    const tCurve& m_Curve;



        // The engine that generates the curve:



    tEngine& m_Engine;



        // The actual samples.



    tHeap<double> m_Sample;



        // Sometimes, we want weighted accumulated curves.



    tHeap<double> m_Accu;



        // Translation of SI's:



    double xlat( int nSub ) {

        return m_gAlpha * nSub + m_gBeta;

    }



    double xlat( double gSub ) {

        return m_gAlpha * gSub + m_gBeta;

    }



    const firstSample() const {

        return m_nFirstSample;

    }



    const lastSample() const {

        return m_nLastSample;

    }



public:



    tCurveInstance( const tCurve& Curve, tEngine& Engine );



    virtual ~tCurveInstance();



    const tCurve& curve() const {

        return m_Curve;

    }



        // Since m_Sample is in the date base of the

        // curve, which might be different, we need to

        // compute translation factors. NOTE that if you

        // override this function in a subclass, it must

        // still be called!



    virtual tRetCode prepare();



        // evaluate() might be called many times, for

        // instance by a Monte Carlo engine. The evaluation 

        // is done over the entire curve, weighted by the

        // weight.



    virtual tRetCode evaluate( double gWeight ) = 0;



    virtual tRetCode postProcess( double gWeight = -1 );



        // heuristic error recovery:



    void zero();

    void reweigh( double gBadWeight );



        // If several curves are computed, some might share

        // the data after evaluation, before postProcess()

        // is called, through the following interface:



    virtual bool containsEvaluationOf( const tCurveInstance& Instance ) const;

    virtual tRetCode stealEvaluationFrom( const tCurveInstance& Instance );



        // Data access (m_Accu will be used if it is initialized):



    const tHeap<double>& sample() const;

};



MTG_END_NAMESPACE



#endif

