// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_CUSTOM_CLAIM_)

#define _MTG_CUSTOM_CLAIM_



#include "MtgClaim.h"

#include "MtgCashflow.h"

#include "MtgLookup.h"



MTG_BEGIN_NAMESPACE



class tExPolicyExpr;

class tNumericalExpr;

class tParser;

class tPortfolio;





//

//   t C u s t o m C l a i m

//

    

class tCustomClaim : public tClaim {



    typedef tClaim super;



        // define custom cashflow structure:



    class tCustomCashflow : public tCashflow {



    public:



        tNumericalExpr* m_pExpr;



        tCustomCashflow( tSystem& System, int nDay, tNumericalExpr* pExpr );

        tCustomCashflow( tSystem& System, tDate Date, tNumericalExpr* pExpr );



        tCustomCashflow( const tCustomCashflow& CC );



        ~tCustomCashflow();



        tCashflow* clone() const;



        double generate( tEngine& Engine, const tClaim& Claim );

    };



    tNumericalExpr *m_pPayoff;

    tNumericalExpr *m_pKnockoutPayoff;

    tNumericalExpr *m_pExercisePayoff;



    tNumericalExpr *m_pUpBarrier;

    tNumericalExpr *m_pDownBarrier;



    tExPolicyExpr *m_pMonitor;



    void init();



        // NOTE that when registering statement ownership is transferred

        // to the tCustomClaim object.



    void regCashflow( int nDay, tNumericalExpr *pCashflow );

    void regCashflow( tDate Date, tNumericalExpr *pCashflow );



    void getEvents( tSeqEvGenerator& EvGen ) const;



    void getBarriers( const tFactor* pFactor, bool bMain,

        tHeap<double>& Barrier ) const;        



    double payoff( tEngine& Engine );

    double knockoutPayoff( tEngine& Engine );

    double exercisePayoff( tEngine& Engine );



    bool upBarrier( tEngine& Engine, double& gBarrier );

    bool downBarrier( tEngine& Engine, double& gBarrier );



    tExPolicy monitor( tEngine& Engine, double gUnitValue );



    tRetCode parseBarrier( tParser& Parser );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

        

public:



    tCustomClaim();

    tCustomClaim( const tCustomClaim& Claim );



    ~tCustomClaim();



    tCustomClaim& operator=( const tCustomClaim& Claim );



    void copyFrom( const tCustomClaim& Claim );



    tObject* clone() const;



    tRetCode finalize();



    tRetCode resolve( tLookup<int>& Claim, tLookup<int>& Factor,

        tHeap<tFactor*>& FactorPtr, tPortfolio& Pf );



    bool addPaymentStream( tInterestSpline& Spline ) const;

};



MTG_END_NAMESPACE



#endif

