// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgDateFormat.h"



MTG_BEGIN_NAMESPACE





//

//   c l e a n u p

//



void tDateFormat::cleanup()



{

    if( m_sFormat != 0 ) {

        delete m_sFormat;

        m_sFormat = 0;

    }

    if( m_sBuffer != 0 ) {

        delete m_sBuffer;

        m_sBuffer = 0;

    }

}





//

//   f o r m a t

//



char* tDateFormat::format() const



{

    char sBuffer[128];



    static const char* AbbrWeekday[] = {

        "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"

    };



    static const char* FullWeekday[] = {

        "Sunday", "Monday", "Tuesday", "Wednesday",

        "Thursday", "Friday", "Saturday"

    };



    static const char* AbbrMonth[] = {

        "Jan", "Feb", "Mar", "Apr", "Mai", "Jun",

        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"

    };



    static const char* FullMonth[] = {

        "January", "February", "March", "April", "Mai", "June",

        "July", "August", "September", "October", "November", "December"

    };



    const char *s;

    char s1[16];



    char *p = m_sFormat;

    int k = 0;



    while( *p && k < sizeof(sBuffer) - 1 ) {

        if( *p == '%' ) {

            s = s1;



            switch( *++p ) {

                case 'a' : // Abbreviated weekday name

                    s = AbbrWeekday[m_Date.weekday()];

                    break;



                case 'A' : // Full weekday name

                    s = FullWeekday[m_Date.weekday()];

                    break;



                case 'b' : // Abbreviated month name

                    s = AbbrMonth[m_Date.month() - 1];

                    break;



                case 'B' : // Full month name

                    s = FullMonth[m_Date.month() - 1];

                    break;



                case 'd' : // Day of month as decimal number (01 - 31)

                    sprintf( s1, "%02d", m_Date.day() );

                    break;



                case 'j' : // Day of year as decimal number (001-366)

                    sprintf( s1, "%03ld", m_Date - tDate( 1, 1, m_Date.year() ) );

                    break;



                case 'm' : // Month as decimal number (01 - 12)

                    sprintf( s1, "%02d", m_Date.month() );

                    break;



                case 'w' : // Weekday as decimal number (0 - 6, Sunday is 0)

                    sprintf( s1, "%d", m_Date.weekday() );

                    break;



                case 'y' : // Year without century, as decimal number (00 - 99)

                    sprintf( s1, "%02d", m_Date.year() % 100 );

                    break;



                case 'Y' : // Year with century, as decimal number

                    sprintf( s1, "%04d", m_Date.year() );

                    break;



                default :

                    s = 0;

                    sBuffer[k++] = *p;

                    break;

            }



            if( s != 0 ) {

                int l = strlen( s );



                if( k + l >= sizeof(sBuffer) )

                    break;

                strcpy( &sBuffer[k], s );

                k += l;

            }

        }

        else {

            sBuffer[k++] = *p;

        }

        ++p;

    }



    sBuffer[k] = 0;

    return StrCopy( sBuffer );

}





//

//   t D a t e F o r m a t

//



tDateFormat::tDateFormat()



{

    m_sFormat = StrCopy( "%m/%d/%y" );

    m_sBuffer = format();

}





//

//   t D a t e F o r m a t

//



tDateFormat::tDateFormat( const char* sFormat )



{

    MTG_ASSERT( sFormat != 0 );



    m_sFormat = StrCopy( sFormat );

    m_sBuffer = format();

}





//

//   t D a t e F o r m a t

//



tDateFormat::tDateFormat( const char* sFormat, tDate Date )



{

    MTG_ASSERT( sFormat != 0 );



    m_sFormat = StrCopy( sFormat );

    m_Date = Date;

    m_sBuffer = format();

}





//

//   t D a t e F o r m a t

//



tDateFormat::tDateFormat( const tDateFormat& Format )



{

    m_sFormat = StrCopy( Format.m_sFormat );

    m_sBuffer = StrCopy( Format.m_sBuffer );

    m_Date = Format.m_Date;

}





//

//   ~ t D a t e F o r m a t

//



tDateFormat::~tDateFormat()



{

    cleanup();

}





//

//   o p e r a t o r =

//



tDateFormat& tDateFormat::operator=( const tDateFormat& Format )



{

    if( &Format != this ) {

        cleanup();

        m_sFormat = StrCopy( Format.m_sFormat );

        m_sBuffer = StrCopy( Format.m_sBuffer );

        m_Date = Format.m_Date;

    }

    return *this;

}





//

//   o p e r a t o r ( )

//



const char* tDateFormat::operator()( tDate Date )



{

    m_Date = Date;

    if( m_sBuffer != 0 )

        delete m_sBuffer;

    m_sBuffer = format();

    return m_sBuffer;

}





//

//   o p e r a t o r ( )

//



const char* tDateFormat::operator()() const



{

    return m_sBuffer ? m_sBuffer : "";

}





//

//   o p e r a t o r < <

//



ostream& operator<<( ostream& Out, const tDateFormat& Format )



{

    return Out << Format();

}



MTG_END_NAMESPACE

