// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgDateRange.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tDateRange::copyFrom( const tDateRange& Range )



{

    if( this == &Range )

        return;



    m_nNumOfSamples = Range.m_nNumOfSamples;

    super::copyFrom( Range );

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange()



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( tScale nScale )

    : super( nScale )



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( tScale nScale, int nNumOfPeriods )

    : super( nScale, nNumOfPeriods )



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( tScale nScale, const tDayCount& DayCount )

    : super( nScale, DayCount )



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( tScale nScale, int nNumOfPeriods,

    const tDayCount& DayCount )

    : super( nScale, nNumOfPeriods, DayCount )



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( tScale nScale, const tDayCount& DayCount,

    tDate Base )

    : super( nScale, DayCount, Base )



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( tScale nScale, int nNumOfPeriods,

    const tDayCount& DayCount, tDate Base )

    : super( nScale, nNumOfPeriods, DayCount, Base )



{

    m_nNumOfSamples = 0;

}





//

//   t D a t e R a n g e

//



tDateRange::tDateRange( const tDateRange& Range )



{

    m_nNumOfSamples = Range.m_nNumOfSamples;

}





//

//   ~ t D a t e R a n g e

//



tDateRange::~tDateRange()



{

}





//

//   o p e r a t o r =

//



tDateRange& tDateRange::operator=( const tDateRange& Range )



{

    if( this != &Range )

        copyFrom( Range );

    return *this;

}





//

//   s e t N u m O f S a m p l e s

//



void tDateRange::setNumOfSamples( int nNumOfSamples )



{

    MTG_ASSERT( nNumOfSamples >= 0 );

    m_nNumOfSamples = nNumOfSamples;

}





//

//   s e t N u m O f S a m p l e s

//



void tDateRange::setNumOfSamples( tDate Maturity, bool bCovering )



{

    MTG_ASSERT( Maturity >= base() );



    if( scale() == xDay ) {

        m_nNumOfSamples = dayCount().numOfDays( base(), Maturity );

    }

    else {

        double f =

            numOfPeriods() * dayCount().fraction( base(), Maturity );



        m_nNumOfSamples = (int) floor( f );

        if( m_nNumOfSamples < f && bCovering )

            ++m_nNumOfSamples;

    }

}





//

//   d u r a t i o n

//



double tDateRange::duration() const



{

    return duration( base() );

}





//

//   d u r a t i o n

//



double tDateRange::duration( tDate Base ) const



{

    if( base() == Base )

        return dtSI() * m_nNumOfSamples;

    return dtSI() * m_nNumOfSamples + dayCount().fraction( Base, base() );

}





//

//   i s C o v e r e d S I

//



bool tDateRange::isCoveredSI( int nSub ) const



{

    return nSub >= 0 && nSub < m_nNumOfSamples;

}





//

//   i s C o v e r e d S I

//



bool tDateRange::isCoveredSI( double gSub ) const



{

    return gSub >= 0 && gSub < m_nNumOfSamples;

}





//

//   i s C o v e r e d T U

//



bool tDateRange::isCoveredTU( int nUnit ) const



{

    return isCoveredSI( nUnit * numOfPeriods() );

}





//

//   i s C o v e r e d T U

//



bool tDateRange::isCoveredTU( double gUnit ) const



{

    return isCoveredSI( gUnit * numOfPeriods() );

}





//

//   i s C o v e r e d

//



bool tDateRange::isCovered( tDate Date ) const



{

    if( scale() == xDay ) {

        int n;



        getSI( Date, n );

        return isCoveredSI( n );

    }



    return isCoveredSI( getSI( Date ) );

}



MTG_END_NAMESPACE

