// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgDayShift.h"

#include "MtgParser.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tDayShift::copyFrom( const tDayShift& Shift )



{

}





//

//   t D a y S h i f t

//



tDayShift::tDayShift()



{

}





//

//   t D a y S h i f t

//



tDayShift::tDayShift( const tDayShift& Shift )



{

    copyFrom( Shift );

}





//

//   ~ t D a y S h i f t

//



tDayShift::~tDayShift()



{

}





//

//   p a r s e

//



tRetCode tDayShift::parse( tParser& Parser, tDayShift*& pShift )



{

    tRetCode nRet;

    tDate Date;



    pShift = 0;



    switch( Parser.curToken() ) {

        case xTokIdentity :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;

            pShift = new tIdentityDayShift;

            break;



        case xTokFixed :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;

            // fall through



        case xTokString :

        case xTokDate :

            if( ( nRet = Parser.scanDate( Date ) ) != OK )

                return nRet;

            pShift = new tFixedDayShift( Date );

            break;



        case xTokFollowing :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;

            if( Parser.curToken() == xTokNumber ) {

                int nAdvance;



                if( ( nRet = Parser.scanInteger( nAdvance, -1 ) ) != OK )

                    return nRet;

                pShift = new tFollowingDayShift( nAdvance );

            }

            else {

                pShift = new tFollowingDayShift;

            }

            break;



        case xTokModified :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;

            pShift = new tModifiedDayShift;

            break;



        case xTokPreceding :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;

            if( Parser.curToken() == xTokNumber ) {

                int nBacktrack;



                if( ( nRet = Parser.scanInteger( nBacktrack, -1 ) ) != OK )

                    return nRet;

                pShift = new tPrecedingDayShift( nBacktrack );

            }

            else {

                pShift = new tPrecedingDayShift;

            }

            break;



        default :

            break;

    }



    return OK;

}





//

//   c o p y F r o m

//



void tIdentityDayShift::copyFrom( const tIdentityDayShift& Shift )



{

    if( &Shift == this )

        return;

    super::copyFrom( Shift );

}





//

//   t I d e n t i t y D a y S h i f t

//



tIdentityDayShift::tIdentityDayShift()



{

}





//

//   t I d e n t i t y D a y S h i f t

//



tIdentityDayShift::tIdentityDayShift( const tIdentityDayShift& Shift )



{

    copyFrom( Shift );

}





//

//   ~ t I d e n t i t y D a y S h i f t

//



tIdentityDayShift::~tIdentityDayShift()



{

}





//

//   c l o n e

//



tDayShift* tIdentityDayShift::clone() const



{

    return new tIdentityDayShift( *this );

}





//

//   s h i f t

//



tDate tIdentityDayShift::shift( tDate Date ) const



{

    return Date;

}





//

//   c o p y F r o m

//



void tFixedDayShift::copyFrom( const tFixedDayShift& Shift )



{

    if( &Shift == this )

        return;



    m_FixedDate = Shift.m_FixedDate;

    super::copyFrom( Shift );

}





//

//   t F i x e d D a y S h i f t

//



tFixedDayShift::tFixedDayShift()



{

    m_FixedDate = tDate::today();

}





//

//   t F i x e d D a y S h i f t

//



tFixedDayShift::tFixedDayShift( tDate FixedDate )



{

    m_FixedDate = FixedDate;

}





//

//   t F i x e d D a y S h i f t

//



tFixedDayShift::tFixedDayShift( const tFixedDayShift& Shift )



{

    copyFrom( Shift );

}





//

//   ~ t F i x e d D a y S h i f t

//



tFixedDayShift::~tFixedDayShift()



{

}





//

//   c l o n e

//



tDayShift* tFixedDayShift::clone() const



{

    return new tFixedDayShift( m_FixedDate );

}





//

//   s h i f t

//



tDate tFixedDayShift::shift( tDate Date ) const



{

    return m_FixedDate;

}





//

//   c o p y F r o m

//



void tFollowingDayShift::copyFrom( const tFollowingDayShift& Shift )



{

    if( &Shift == this )

        return;



    m_nAdvance = Shift.m_nAdvance;

    super::copyFrom( Shift );

}





//

//   t F o l l o w i n g D a y S h i f t

//



tFollowingDayShift::tFollowingDayShift()



{

    m_nAdvance = 0;

}





//

//   t F o l l o w i n g D a y S h i f t

//



tFollowingDayShift::tFollowingDayShift( int nAdvance )



{

    m_nAdvance = nAdvance;

}





//

//   t F o l l o w i n g D a y S h i f t

//



tFollowingDayShift::tFollowingDayShift( const tFollowingDayShift& Shift )



{

    copyFrom( Shift );

}





//

//   ~ t F o l l o w i n g D a y S h i f t

//



tFollowingDayShift::~tFollowingDayShift()



{

}





//

//   o p e r a t o r =

//



tFollowingDayShift& tFollowingDayShift::operator=(

    const tFollowingDayShift& Shift )



{

    if( &Shift != this )

        copyFrom( Shift );

    return *this;

}





//

//   c l o n e

//



tDayShift* tFollowingDayShift::clone() const



{

    return new tFollowingDayShift( *this );

}





//

//   s e t

//



void tFollowingDayShift::set( int nAdvance )



{

    m_nAdvance = nAdvance;

}





//

//   s h i f t

//



tDate tFollowingDayShift::shift( tDate Date ) const



{

    if( m_nAdvance < 0 )

        return Date;        // do nothing

    return Date.nextBusinessday( m_nAdvance );

}





//

//   c o p y F r o m

//



void tPrecedingDayShift::copyFrom( const tPrecedingDayShift& Shift )



{

    if( &Shift == this )

        return;



    m_nBacktrack = Shift.m_nBacktrack;

    super::copyFrom( Shift );

}





//

//   t P r e c e d i n g D a y S h i f t

//



tPrecedingDayShift::tPrecedingDayShift()



{

    m_nBacktrack = 0;

}





//

//   t P r e c e d i n g D a y S h i f t

//



tPrecedingDayShift::tPrecedingDayShift( int nBacktrack )



{

    m_nBacktrack = nBacktrack;

}





//

//   t P r e c e d i n g D a y S h i f t

//



tPrecedingDayShift::tPrecedingDayShift( const tPrecedingDayShift& Shift )



{

    copyFrom( Shift );

}





//

//   ~ t P r e c e d i n g D a y S h i f t

//



tPrecedingDayShift::~tPrecedingDayShift()



{

}





//

//   o p e r a t o r =

//



tPrecedingDayShift& tPrecedingDayShift::operator=(

    const tPrecedingDayShift& Shift )



{

    if( &Shift != this )

        copyFrom( Shift );

    return *this;

}





//

//   c l o n e

//



tDayShift* tPrecedingDayShift::clone() const



{

    return new tPrecedingDayShift( *this );

}





//

//   s e t

//



void tPrecedingDayShift::set( int nBacktrack )



{

    m_nBacktrack = nBacktrack;

}





//

//   s h i f t

//



tDate tPrecedingDayShift::shift( tDate Date ) const



{

    if( m_nBacktrack < 0 )

        return Date;        // do nothing

    return Date.prevBusinessday( m_nBacktrack );

}





//

//   c o p y F r o m

//



void tModifiedDayShift::copyFrom( const tModifiedDayShift& Shift )



{

    if( &Shift == this )

        return;

    super::copyFrom( Shift );

}





//

//   t M o d i f i e d D a y S h i f t

//



tModifiedDayShift::tModifiedDayShift()



{

}





//

//   t M o d i f i e d D a y S h i f t

//



tModifiedDayShift::tModifiedDayShift( const tModifiedDayShift& Shift )



{

    copyFrom( Shift );

}





//

//   ~ t M o d i f i e d D a y S h i f t

//



tModifiedDayShift::~tModifiedDayShift()



{

}





//

//   o p e r a t o r =

//



tModifiedDayShift& tModifiedDayShift::operator=(

    const tModifiedDayShift& Shift )



{

    if( &Shift != this )

        copyFrom( Shift );

    return *this;

}





//

//   c l o n e

//



tDayShift* tModifiedDayShift::clone() const



{

    return new tModifiedDayShift( *this );

}





//

//   s h i f t

//



tDate tModifiedDayShift::shift( tDate Date ) const



{

        // If the date is a businessday - fine:



    if( Date.isBusinessday() )

        return Date;



        // See if the next businessday falls into the

        // same month:



    tDate d = Date.nextBusinessday();

    if( d.month() == Date.month() )

        return d;



    return Date.prevBusinessday();

}



MTG_END_NAMESPACE





//#define _TEST

#if defined(_TEST)



#if defined(_WIN32)

    #include <conio.h>

#else

    #define getche getchar

#endif



MTG_USING_NAMESPACE



//

//   m a i n

//



void main( int argc, char *argv[] )



{

    printf( "\nTest tDayShift\n\n" );



    struct T {

        const char* m_sText;

        tDayShift* m_pShift;

    } Shift[] = {

        { "Identity    ", new tIdentityDayShift() },

        { "Modified    ", new tModifiedDayShift() },

        { "Following-0 ", new tFollowingDayShift( 0 ) },

        { "Following-1 ", new tFollowingDayShift( 1 ) },

        { "Following-2 ", new tFollowingDayShift( 2 ) },

        { "Following-3 ", new tFollowingDayShift( 3 ) },

        { "Following-7 ", new tFollowingDayShift( 7 ) },

        { "Following-10", new tFollowingDayShift( 10 ) },

        { "Preceding-0 ", new tPrecedingDayShift( 0 ) },

        { "Preceding-1 ", new tPrecedingDayShift( 1 ) },

        { "Preceding-2 ", new tPrecedingDayShift( 2 ) },

        { "Preceding-3 ", new tPrecedingDayShift( 3 ) },

        { "Preceding-7 ", new tPrecedingDayShift( 7 ) },

        { "Preceding-10", new tPrecedingDayShift( 10 ) },

    };



    char sBuf[256];

    int cCmd;

    tDate D;



    bool bGo = true;



    while( bGo ) { 

        printf( "<D>ate E<x>it: " );

        cCmd = getche();

        printf( "\n" );



        switch( cCmd ) {

            case 'd' :

            case 'D' :

                printf( "Date: " );

                gets( sBuf );

                if( D.set( sBuf ) == 0 ) {

                    printf( "Format error\n" );

                }

                else {

                    for( int i = 0; i < sizeof(Shift) / sizeof(T); ++i ) {

                        tDate E = Shift[i].m_pShift->shift( D );



                        printf( "%s: ", Shift[i].m_sText );

                        printf( "%02d/%02d/%d %d\n",

                            E.month(), E.day(), E.year(), E.weekday() );

                    }

                }

                break;



            case 'x' :

            case 'X' :

                bGo = false;

                break;

        }

    }



#if ! defined(_WIN32)

    printf( "\n" );

#endif

}



#endif