// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"



#if defined(_WIN32)

  #include <crtdbg.h>

#endif



MTG_BEGIN_NAMESPACE



#if defined(_DEBUG)



#if defined(_WIN32)



//

//   a l l o c H o o k

//



static int allocHook( int nAllocType, void* pData, size_t nSize, 

   int nBlockUse, long nRequest, const char* sFileName, int nLine )



{

    const char* aOperation[] =

        { "", "allocating", "re-allocating", "freeing" };



    const char* aBlockType[] =

        { "free", "normal", "CRT", "ignore", "vlient" };



    if( nBlockUse == _CRT_BLOCK )

        return 1;

   

        // For special purposes, this allocation hook can be

        // modified to print a trace of memory operations.



    if( sFileName != 0 )

        MTG_TRACE( "Memory operation in %s, line %d: ", sFileName, nLine );

    else

        MTG_TRACE( "Memory operation: " );



    MTG_TRACE( "%s a %d-byte '%s' block (# %ld)\n",

        aOperation[nAllocType], nSize, 

        aBlockType[nBlockUse], nRequest );

   

    return 1;

}



#endif



//

//   A s s e r t F a i l e d

//



void AssertFailed( const char *sExpr,

    const char *sFile, int nLine )



{

#if defined(_WIN32)

    _CrtSetReportMode( _CRT_ASSERT, _CRTDBG_MODE_WNDW );

    if( _CrtDbgReport( _CRT_ASSERT,

            sFile, nLine, NULL, "%s", sExpr ) == 1 ) {

        _CrtDbgBreak();

        return;

    }

  

#else



    fprintf( stderr, "\n\n*** Assertion failed in %s, %d:\n*** %s\n\n",

        sFile, nLine, sExpr );



#endif



    exit( 1 );

}





//

//   T r a c e

//



void Trace( const char *sFmt, ... )



{

    va_list Marker;

    va_start( Marker, sFmt );



#if defined(_WIN32)

    vprintf( sFmt, Marker );

#else

    char sBuffer[4096];

    vsprintf( sBuffer, sFmt, Marker );

    fprintf( stderr, "%s", sBuffer );

#endif

}





//

//   I n i t M e m o r y

//



void InitMemory()



{

#if defined(_WIN32)

    _CrtSetDbgFlag(

        _CrtSetDbgFlag( _CRTDBG_REPORT_FLAG ) | _CRTDBG_LEAK_CHECK_DF );

        // Only for special purposes:

    // _CrtSetAllocHook( allocHook );

#endif

}





//

//   R e p o r t M e m o r y

//



void ReportMemory()



{

#if defined(_WIN32)

    _CrtMemState State;



    _CrtMemCheckpoint( &State );

    MTG_TRACE( "Memory: %ld object%s, %ld bytes, high %ld bytes\n",

        State.lCounts[_NORMAL_BLOCK],

        State.lCounts[_NORMAL_BLOCK] == 1 ? "" : "s",

        State.lSizes[_NORMAL_BLOCK],

        State.lHighWaterCount );

#endif

}



//

//   E x i t M e m o r y

//



void ExitMemory()



{

#if defined(_WIN32)

    ReportMemory();

#endif

}



#endif // _DEBUG



MTG_END_NAMESPACE

