// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_DEBUG_)

#define _MTG_DEBUG_



MTG_BEGIN_NAMESPACE





//

//   A S S E R T

//



#if defined(_DEBUG)

    #define MTG_ASSERT( expr ) \

        ( (expr) ? (void) 0 : AssertFailed( #expr, __FILE__, __LINE__ ) )

#else

    #define MTG_ASSERT( expr ) ( (void) 0 )

#endif





//

//   T R A C E

//



#if defined(_DEBUG)

    #define MTG_TRACE Trace

#else

    #define MTG_TRACE 1 ? (void) 0 : Trace

#endif





//

//   f u n c t i o n s

//



#if defined(_DEBUG)    



void AssertFailed( const char *sExpr, const char *sFile, int nLine );

void Trace( const char *sFmt, ... );



void InitMemory();

void ReportMemory();

void ExitMemory();



#else



inline void Trace( const char *sFmt, ... ) {}



inline void InitMemory()   {}

inline void ReportMemory() {}

inline void ExitMemory()   {}

       

#endif



MTG_END_NAMESPACE



#endif

