// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgDtGenerator.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tDtGenerator::init( double gDt0, double gDtN, int nDayN,

    double& gDtIpolA, double& gDtIpolB )



{

    MTG_ASSERT( gDt0 > 0 && gDtN > 0 );



    if( nDayN < 1 )

        gDtIpolA = 0;

    else

        gDtIpolA = ( gDtN - gDt0 ) / nDayN;



    gDtIpolB = gDt0;

}





//

//   m a x D t

//



double tDtGenerator::maxDt( int nMaturity ) const



{

    double dt1 = nextDt( 0 );

    double dt2 = nextDt( nMaturity );

    if( dt1 > dt2 )

        return dt1;

    return dt2;

}





//

//   t L i n D t G e n e r a t o r

//



tLinDtGenerator::tLinDtGenerator( double gDt0, double gDtN, int nDayN )



{

    init( gDt0, gDtN, nDayN, m_gDtIpolA, m_gDtIpolB );

}





//

//   c l o n e

//



tDtGenerator* tLinDtGenerator::clone() const



{

    return new tLinDtGenerator( *this );

}





//

//   n e x t D t

//



double tLinDtGenerator::nextDt( int nDay ) const



{

    double dt = m_gDtIpolA * nDay + m_gDtIpolB;



    if( dt <= 0 ) {

        nDay = (int) ceil( -m_gDtIpolB / m_gDtIpolA - 1 );

        dt = m_gDtIpolA * nDay + m_gDtIpolB;

        MTG_ASSERT( dt > 0 );

    }



    return dt;

}





//

//   t E x p D t G e n e r a t o r

//



tExpDtGenerator::tExpDtGenerator( double gDt0, double gDtN, int nDayN )



{

    MTG_ASSERT( gDt0 > 0 && gDtN > 0 );



    m_gBase = exp( 1 );

    init( log( gDt0 ), log( gDtN ), nDayN, m_gDtIpolA, m_gDtIpolB );

}





//

//   t E x p D t G e n e r a t o r

//



tExpDtGenerator::tExpDtGenerator( double gDt0, double gDtN, int nDayN,

    double gBase )



{

    MTG_ASSERT( gDt0 > 0 && gDtN > 0 && gBase > 0 );



    m_gBase = gBase;

    double d = log( m_gBase );



    init( log( gDt0 ) / d, log( gDtN ) / d, nDayN, m_gDtIpolA, m_gDtIpolB );

}





//

//   c l o n e

//



tDtGenerator* tExpDtGenerator::clone() const



{

    return new tExpDtGenerator( *this );

}





//

//   n e x t D t

//



double tExpDtGenerator::nextDt( int nDay ) const



{

    return pow( m_gBase, m_gDtIpolA * nDay + m_gDtIpolB );

}



MTG_END_NAMESPACE