// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgEvGenerator.h"

#include "MtgPortfolio.h"



MTG_BEGIN_NAMESPACE





//

//   ~ t E v G e n e r a t o r

//



tEvGenerator::~tEvGenerator()



{

}





//

//   i n i t

//



void tSeqEvGenerator::init()



{

    reset();

}





//

//   i n s e r t

//



void tSeqEvGenerator::insert( int nDay )



{

    m_aSeq.sortInAsc( nDay, true );

}





//

//   t S e q E v G e n e r a t o r

//



tSeqEvGenerator::tSeqEvGenerator()



{

    init();

}





//

//   t S e q E v G e n e r a t o r

//



tSeqEvGenerator::tSeqEvGenerator( const tSeqEvGenerator& EvGen )



{

    init();

    copyFrom( EvGen );

}





//

//   ~ t S e q E v G e n e r a t o r

//



tSeqEvGenerator::~tSeqEvGenerator()



{

}





//

//   r e s e t

//



void tSeqEvGenerator::reset()



{

    m_aSeq.reset();

    rewind();

}





//

//   o p e r a t o r =

//



tSeqEvGenerator& tSeqEvGenerator::operator=(

    const tSeqEvGenerator& EvGen )



{

    if( &EvGen != this )

        copyFrom( EvGen );

    return *this;

}





//

//   c o p y F r o m

//



void tSeqEvGenerator::copyFrom( const tSeqEvGenerator& EvGen )



{

    if( &EvGen == this )

        return;



    reset();

    m_aSeq.copyFrom( EvGen.m_aSeq );

    m_nNextEvent = EvGen.m_nNextEvent;

}





//

//   a d d E v e n t

//



void tSeqEvGenerator::addEvent( int nDay )



{

    if( nDay >= 1 ) {

        insert( nDay );

        rewind();

    }

}





//

//   a d d E v e n t

//



void tSeqEvGenerator::addEvent( int nNumOfDays, int aDay[] )



{

    m_aSeq.ensureCapacity( nNumOfDays );

    for( int i = 0; i < nNumOfDays; ++i ) {

        if( aDay[i] >= 1 )

            insert( aDay[i] );

    }

    rewind();

}





//

//   a d d E v e n t

//



void tSeqEvGenerator::addEvent( const tHeap<int>& aDay )



{

    m_aSeq.ensureCapacity( aDay.numOfElems() );

    for( int i = 0; i < aDay.numOfElems(); ++i ) {

        if( aDay[i] >= 1 )

            insert( aDay[i] );

    }

    rewind();

}





//

//   a d d E v e n t

//



void tSeqEvGenerator::addEvent( tEvGenerator& EvGen )



{

    int n;



    if( &EvGen == this )

        return ;



    EvGen.rewind();

    while( ( n = EvGen.nextEvent() ) >= 0 )

        insert( n);

    rewind();

}





//

//   a d d E v e n t

//



void tSeqEvGenerator::addEvent( tPortfolio& Pf )



{

    Pf.getEvents( *this );

}





//

//   c a p

//



void tSeqEvGenerator::cap( int nMaxDay )



{

    while( m_aSeq.numOfElems() > 0 && m_aSeq.last() > nMaxDay )

        m_aSeq.numOfElems( m_aSeq.numOfElems() - 1 );

}





//

//   r e w i n d

//



void tSeqEvGenerator::rewind()



{

    m_nNextEvent = ( m_aSeq.numOfElems() > 0 ) ? 0 : -1;

}





//

//   n e x t E v e n t

//



int tSeqEvGenerator::nextEvent()



{

    if( m_nNextEvent < 0 )

        return -1;



    int nEvent = m_aSeq[m_nNextEvent];



    if( ++m_nNextEvent >= m_aSeq.numOfElems() )

        m_nNextEvent = -1;



    return nEvent;

}





//

//   l a s t E v e n t

//



int tSeqEvGenerator::lastEvent()



{

    if( m_aSeq.numOfElems() == 0 )

        return 0;

    return m_aSeq[m_aSeq.numOfElems() - 1];

}





//

//   t D a i l y E v G e n e r a t o r

//



tDailyEvGenerator::tDailyEvGenerator( int nMaturity )



{

    MTG_ASSERT( nMaturity >= 0 );

    m_nMaturity = nMaturity;

    rewind();

}





//

//   r e w i n d

//



void tDailyEvGenerator::rewind()



{

    m_nNextEvent = ( m_nMaturity >= 1 ) ? 1 : -1;

}





//

//   n e x t E v e n t

//



int tDailyEvGenerator::nextEvent()



{

    int nEvent = m_nNextEvent;



    if( m_nNextEvent >= 0 ) {

        if( ++m_nNextEvent >= m_nMaturity )

            m_nNextEvent = -1;

    }

    return nEvent;

}





//

//   l a s t E v e n t

//



int tDailyEvGenerator::lastEvent()



{

    return m_nMaturity;

}



MTG_END_NAMESPACE

