// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_EVALUATE_)

#define _MTG_EVALUATE_



#include "MtgObject.h"

#include "MtgCurveContainer.h"

#include "MtgImageContainer.h"

#include "MtgProfile.h"

#include "MtgHeap2.h"



MTG_BEGIN_NAMESPACE



class tFDEngine;

class tLattice;

class tMCEngine;

class tModel;

class tOptimizer;

class tPathSpace;

class tPortfolio;

class tScenario;





//

//   t E v a l u a t e

//



class tEvaluate : public tObject, public tWithProfile {



    typedef tObject super;



    struct tParseInfo : super::tParseInfoStub {

        bool m_bAccuracy;

    };



    tLattice* m_pLattice;       // referenced

    tModel* m_pModel;           // referenced

    tPathSpace* m_pPathSpace;   // referenced

    tPortfolio* m_pPortfolio;   // referenced

    tScenario* m_pScenario;     // referenced

    tOptimizer* m_pOptimizer;   // referenced



    tFDEngine* m_pFDEngine;     // owned

    tMCEngine* m_pMCEngine;     // owned



    tCurveContainer m_CurveContainer;

    tImageContainer m_ImageContainer;



    tAccuracy m_nAccuracy;



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



        // Evaluaters are used only once and cannot be cloned.



    tObject* clone() const {

        throw tException( INTERNAL_ERROR );

        return 0;

    }



public:



    tEvaluate();

    ~tEvaluate();



    tRetCode finalize();

    tRetCode run();



        // Some of these functions are not available for

        // Monte Carlo methods:



    double dirtyTotal() const;

    double cleanTotal() const;



        // All values default to the "dirty", non-adjusted

        // versions (as a matter of fact, the greeks and the

        // gradient are only available in that format).



    double total() const {

        return dirtyTotal();

    }



    double delta() const;

    double gamma() const;



    void gradient( tHeap<double>& Gradient ) const;

    void front( tHeap2<double>& Front ) const;



    int numOfTasks() const;



    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );

};



MTG_END_NAMESPACE



#endif

