// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgFileName.h"

#include "MtgParser.h"



MTG_BEGIN_NAMESPACE





//

//   t F i l e N a m e

//



tFileName::tFileName()



{

    m_sName = 0;

    m_bTry = false;

}





//

//   t F i l e N a m e

//



tFileName::tFileName( const char* sName, bool bTry )



{

    m_sName = StrCopy( sName );

    m_bTry = bTry;

}





//

//   t F i l e N a m e

//



tFileName::tFileName( const tFileName& FName )



{

    m_sName = StrCopy( FName.m_sName );

    m_bTry = FName.m_bTry;

}





//

//   ~ t F i l e N a m e

//



tFileName::~tFileName()



{

    if( m_sName != 0 )

        delete m_sName;

}





//

//   o p e r a t o r =

//



tFileName& tFileName::operator=( const tFileName& FName )



{

    if( &FName != this ) {

        setName( FName.m_sName );

        m_bTry = FName.m_bTry;

    }

    return *this;

}





//

//   o p e r a t o r =

//



tFileName& tFileName::operator=( const char* sName )



{

    setName( sName );

    return *this;

}





//

//   s e t N a m e

//



void tFileName::setName( const char* sName )



{

    if( m_sName != 0 )

        delete m_sName;

    m_sName = StrCopy( sName );

}





//

//   s e t T r y

//



void tFileName::setTry( bool bTry )



{

    m_bTry = bTry;

}





//

//   o p e n W r i t e

//



tRetCode tFileName::openWrite( ofstream& Out ) const



{

    MTG_ASSERT( m_sName != 0 );



        // Try to open the file 3 times, in 1 second intervals.

        // Someone else might be sharing the file, and we want

        // it exclusively.



    for( int k = 0; k < 3 && ! Out.is_open(); ++k ) {

        if( k > 0 )

            WaitFor( 1 );

        Out.open( m_sName, ios::out, filebuf::sh_none );

    }



    return Out.is_open() ? OK : WRITE_ERROR;

}





//

//   o p e n W r i t e

//



tRetCode tFileName::openWrite( ofstream& Out, const char* sBanner ) const



{

    tRetCode nRet;



    if( ( nRet = openWrite( Out ) ) != OK )

        return nRet;



    time_t t = time( NULL );

    struct tm T = *localtime( &t );



    Out << "// " << tDate( T );



    char c = Out.fill( '0' );



    Out << " " << setw( 2 ) << T.tm_hour

        << ":" << setw( 2 ) << T.tm_min

        << ":" << setw( 2 ) << T.tm_sec;



    Out.fill( c );



    if( sBanner != 0 )

        Out << " " << sBanner;

    Out << endl;



    return Out.good() ? OK : WRITE_ERROR;

}





//

//   o p e n W r i t e

//



tRetCode tFileName::openWrite( FILE*& pOut ) const



{

    MTG_ASSERT( m_sName != 0 );



        // Try to open the file 3 times, in 1 second intervals.

        // Someone else might be sharing the file, and we want

        // it exclusively.



    pOut = 0;

    for( int k = 0; k < 3 && pOut == 0; ++k ) {

        if( k > 0 )

            WaitFor( 1 );

        pOut = fopen( m_sName, "wb" );

    }



    return pOut != 0 ? OK : WRITE_ERROR;

}





//

//   p a r s e

//



tRetCode tFileName::parse( tParser& Parser, bool bAllowTry )



{

    tRetCode nRet;



    if( Parser.isSafe() )

        return INVALID_KEYWORD;



    if( m_sName != 0 ) {

        delete m_sName;

        m_sName = 0;

    }



    if( Parser.curToken() == xTokTry ) {

        if( ! bAllowTry )

            return Parser.setError( INVALID_KEYWORD );

        m_bTry = true;

        if( ( nRet = Parser.readToken() ) != OK )

            return nRet;

    }

    else {

        m_bTry = false;

    }



    return Parser.scanString( m_sName );

}



MTG_END_NAMESPACE

