// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_FILE_NAME_)

#define _MTG_FILE_NAME_



MTG_BEGIN_NAMESPACE



class tParser;





//

//   t F i l e N a m e

//



class tFileName {



    char* m_sName;      // file name

    bool m_bTry;        // try when reading



public:



    tFileName();

    tFileName( const char* sName, bool bTry = false );

    tFileName( const tFileName& FName );



    ~tFileName();



    tFileName& operator=( const tFileName& FName );

    tFileName& operator=( const char* sName );



        // initialize by piece



    void setName( const char* sName );

    void setTry( bool bTry );



        // access via isValid()/name()



    bool isValid() const {

        return m_sName != 0;

    }



    bool isTry() const {

        return m_bTry;

    }



    const char* name() const {

        MTG_ASSERT( m_sName != 0 );

        return m_sName;

    }



        // cast operator for printing the name etc...



    operator const char*() const {

        return m_sName ? m_sName : "";

    }



        // open for writing

        

    tRetCode openWrite( ofstream& Out ) const;

    tRetCode openWrite( ofstream& Out, const char* sBanner ) const;



        // this version (for packages like GD) opens in BINARY mode:



    tRetCode openWrite( FILE*& pOut ) const;



        // parse from script



    tRetCode parse( tParser& Parser, bool bAllowTry = false );



    tRetCode parseRead( tParser& Parser ) {

        return parse( Parser, true );

    }



    tRetCode parseWrite( tParser& Parser ) {

        return parse( Parser, false );

    }

};



MTG_END_NAMESPACE



#endif

