// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_FORWARD_CURVE_)

#define _MTG_FORWARD_CURVE_



#include "MtgCurve.h"

#include "MtgCurveInstance.h"



MTG_BEGIN_NAMESPACE





//

//   t F o r w a r d C u r v e

//



class tForwardCurve : public tCurve {



    typedef tCurve super;



        // This is the curve instance:



    class tForwardCurveInstance : public tCurveInstance {



        typedef tCurveInstance super;



    public:



        tForwardCurveInstance( const tForwardCurve& Curve,

            tEngine& Engine );



        ~tForwardCurveInstance();



        tRetCode evaluate( double gWeight );

        tRetCode postProcess( double gWeight = -1 );



        bool containsEvaluationOf( const tCurveInstance& Instance ) const;

    };



    void copyFrom( const tForwardCurve& Curve );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );



public:



    tForwardCurve();



        // Passed on to the tCurve constructor (see tDateBase.h

        // for changing the values manually):



    tForwardCurve( tScale nScale );

    tForwardCurve( tScale nScale, int nNumOfPeriods );

    tForwardCurve( tScale nScale, const tDayCount& DayCount );

    tForwardCurve( tScale nScale, int nNumOfPeriods,

        const tDayCount& DayCount );

    tForwardCurve( tScale nScale, const tDayCount& DayCount,

        tDate Base );

    tForwardCurve( tScale nScale, int nNumOfPeriods,

        const tDayCount& DayCount, tDate Base );



    tForwardCurve( const tForwardCurve& Curve );



    ~tForwardCurve();



    tForwardCurve& operator=( const tForwardCurve& Curve );



    tObject* clone() const;



    tRetCode finalize();



    tRetCode createInstance( tEngine& Engine,

        tCurveInstance*& pCurve ) const;

};



MTG_END_NAMESPACE



#endif

