// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgGeoEngine.h"

#include "MtgBSModel.h"

#include "MtgClaim.h"

#include "MtgScenario.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tGeoEngine::init()



{

}





//

//   g e t P r o c e s s P a r a m s

//



const tOFSolver::tProcessParamsStub& tGeoEngine::getProcessParams(

    int& nLevel, int nNumOfUpLevels )



{

    MTG_ASSERT( nLevel <= nNumOfUpLevels );



    int nFromLevel = nLevel;



    if( pricedAtPrior() ) {

        m_Params.m_gVol = m_gPriorVol;

        nLevel = nNumOfUpLevels;

    }

    else {

        const tGeoSolver& Solver =

            dynamic_cast<const tGeoSolver&>( solver() );



        double gGamma, gVol;



            // Even in implicit mode, the volatility is chosen

            // explicitely, via gamma.



        if( m_bUseNextParams ) {

                

                // The use of m_bUseNextParams requires that

                // this function is called repeatedly and

                // contiguously for all levels.



            m_Params = m_NextParams;

            m_bUseNextParams = false;

        }

        else {

            gGamma = Solver.calcGamma( nLevel,

                m_pLayer->lastTotal( nLevel + 1 ),

                m_pLayer->lastTotal( nLevel ),

                m_pLayer->lastTotal( nLevel - 1 ) );



            m_Params.m_gVol = scenario().selectVol( m_pLayer->tag(),

                gGamma, m_gPriorVol, m_gMinVol, m_gMaxVol );

        }



        double gLastD = m_pLayer->lastTotal( nLevel );

        double gLastM = m_pLayer->lastTotal( nLevel + 1 );



        do{ 

                // Now see if next level has same volatility.



            if( nLevel < nNumOfUpLevels ) {

                ++nLevel;



                double gLastU = m_pLayer->lastTotal( nLevel + 1 );



                gGamma = Solver.calcGamma( nLevel, gLastU, gLastM, gLastD );



                gVol = scenario().selectVol( m_pLayer->tag(), gGamma,

                    m_gPriorVol, m_gMinVol, m_gMaxVol );



                    // Here is the combinatorial way of doing things,

                    // used in VOP, for instance. We keep this here

                    // for reference. Note that if one wants to use

                    // this code fragment, the first call to calcGamma()

                    // above must also be updated.



                    // double gPU, gPD, gPM, a, b;

                    // 

                    // Solver.calcProb( nLevel, m_gMinVol, m_gMu, 

                    //     relDuration(), gPU, gPD );

                    // gPM = 1 - gPU - gPD;

                    // 

                    // a = gPU * gLastU + gPM * gLastM + gPD * gLastD;

                    // 

                    // Solver.calcProb( nLevel, m_gMaxVol, m_gMu,

                    //     relDuration(), gPU, gPD );

                    // gPM = 1 - gPU - gPD;

                    //

                    // b = gPU * gLastU + gPM * gLastM + gPD * gLastD;

                    // 

                    // if( scenario().endureOver( m_pLayer->tag(), a, b ) ) {

				    //     gVol = m_gMinVol;

                    // }

			        // else {

				    //     gVol = m_gMaxVol;

			        // }



                    // End of combinatorial way of doing things.



                if( gVol != m_Params.m_gVol ) {

                    m_NextParams = m_Params;

                    m_NextParams.m_gVol = gVol;

                    m_bUseNextParams = true;

                    --nLevel;

                    break;

                }



                gLastD = gLastM;

                gLastM = gLastU;

            }

        } while( nLevel < nNumOfUpLevels );

    }



    if( hasProfile() ) {

        for( int k = nFromLevel; k <= nLevel; ++k ) {

            profile().putLevel( k );

            profile().putVolatility( m_Params.m_gVol );

        }

    }



    return m_Params;

}





//

//   s c a l e d A b s D u r a t i o n

//



double tGeoEngine::scaledAbsDuration() const



{

    switch( dynamic_cast<const tBSModel&>( model() ).scale() ) {

        case xDay :

            return absDuration();



        case xYear :

            return absDuration() * model().dayUnit();

    }



    throw tException( INTERNAL_ERROR );

    return 0;

}





//

//   b e f o r e T a s k 1

//



void tGeoEngine::beforeTask1( tSlotLayer& Layer, tSpecific*& pSpecific )



{

    super::beforeTask1( Layer, pSpecific );



    double gDayUnit, gDayUnit2;



    gDayUnit = model().dayUnit();

    gDayUnit2 = sqrt( gDayUnit );



    const tBSModel& BS = dynamic_cast<const tBSModel&>( model() );



    BS.getDrift( day(), toDay(), m_gDiscount, m_gMu );

    BS.getVol( day(), toDay(), m_gPriorVol, m_gMinVol, m_gMaxVol );



        // If the calculations are performed on a day-base, the

        // year-based drift and volatility parameters have to be scaled

        // down. Otherwise, only the continuously compounded discount

        // for the period in question has to be rescaled down, as

        // absDuration() returns the length of the period in days.



    switch( BS.scale() ) {

        case xDay :

            m_gDiscount *= gDayUnit;

            m_gCCDiscount = exp( -m_gDiscount * absDuration() );



            m_gMu *= gDayUnit;

    

            m_gPriorVol *= gDayUnit2;

            m_gMinVol *= gDayUnit2;

            m_gMaxVol *= gDayUnit2;

            break;



        case xYear :

            m_gCCDiscount = exp( -m_gDiscount * absDuration() * gDayUnit );

            break;

    }



        // Switch from non-linearity to linearity?



    if( BS.isLinear( day() ) && mode() == xNonLinear )

        setLinear();



    m_Params.m_gDrift = m_gMu;

    m_Params.m_gDiscount = m_gDiscount;

    m_Params.m_gCCDiscount = m_gCCDiscount;

    m_bUseNextParams = false;

}





//

//   t G e o E n g i n e

//



tGeoEngine::tGeoEngine()



{

    init();

}





//

//   ~ t G e o E n g i n e

//



tGeoEngine::~tGeoEngine()



{

}



MTG_END_NAMESPACE