// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_GEOENGINE_)

#define _MTG_GEOENGINE_



#include "MtgOFEngine.h"

#include "MtgOFSolver.h"

#include "MtgGeoSolver.h"



MTG_BEGIN_NAMESPACE





//

//   t G e o E n g i n e

//



class tGeoEngine : public tOFEngine {



    typedef tOFEngine super;



        // All these variables are used as temporaries.



    double m_gDiscount;

    double m_gCCDiscount;   // continuously compounded discount for

                            // the period in question

    double m_gMu;



    double m_gPriorVol;

    double m_gMinVol;

    double m_gMaxVol;



        // Serves to pass vol, drift and discount to the

        // object that handle implicit or explicit methods:



    tGeoSolver::tProcessParams m_Params;



        // When finding regions of identical parameters,

        // these variables are useful:



    bool m_bUseNextParams;

    tGeoSolver::tProcessParams m_NextParams;



    void init();



        // Called from tOFSolver:



    const tOFSolver::tProcessParamsStub& getProcessParams(

        int& nLevel, int nNumOfUpLevels );



        // Depending on the preferences stored in the model

        // object, calculations are based on days or years.

        // In the latter case, the absolut duration of the

        // timestep has to be rescaled.



    double scaledAbsDuration() const;



    friend class tGeoExplicit;

    friend class tGeoImplicit;



protected:



    void beforeTask1( tSlotLayer& Layer, tSpecific*& pSpecific );



public:



    tGeoEngine();

    ~tGeoEngine();

};



MTG_END_NAMESPACE



#endif

