// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgGeoExplicit.h"

#include "MtgClaim.h"

#include "MtgGeoSpaceAxis.h"

#include "MtgOFEngine.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tGeoExplicit::init()



{

}





//

//   e x t r a p o l a t e U p B o u n d a r y

//



void tGeoExplicit::extrapolateUpBoundary( tFDEngine& Engine,

    tSlotLayer& Layer, int nLevel )



{

    double* Sample1 = Layer.lastRow( nLevel );

    double* Sample2 = Layer.lastRow( nLevel - 1 );

    double* Sample3 = Layer.lastRow( nLevel - 2 );



    double* Last = Layer.lastRow( nLevel + 1 );

    double& Total = Layer.lastTotal( nLevel + 1 );



    Total = 0;



    for( tSlotLayer::tIter I( Layer ); I; ++I ) {

        if( I.claim().maturity() > Engine.day() ) {

            int nPos = I.xlat();



            Last[nPos] = 3 * ( Sample1[nPos] - Sample2[nPos] ) + Sample3[nPos];

            Total += Engine.multiplier( I.index() ) * Last[nPos];

        }

    }

}





//

//   e x t r a p o l a t e D o w n B o u n d a r y

//



void tGeoExplicit::extrapolateDownBoundary( tFDEngine& Engine,

    tSlotLayer& Layer, int nLevel )

    

{

    double* Sample1 = Layer.lastRow( nLevel );

    double* Sample2 = Layer.lastRow( nLevel + 1 );

    double* Sample3 = Layer.lastRow( nLevel + 2 );



    double* Last = Layer.lastRow( nLevel - 1 );

    double& Total = Layer.lastTotal( nLevel - 1 );



    Total = 0;



    for( tSlotLayer::tIter I( Layer ); I; ++I ) {

        if( I.claim().maturity() > Engine.day() ) {

            int nPos = I.xlat();



            Last[nPos] = 3 * ( Sample1[nPos] - Sample2[nPos] ) + Sample3[nPos];

            Total += Engine.multiplier( I.index() ) * Last[nPos];

        }

    }

}





//

//   c a l c W e i g h t s

//



void tGeoExplicit::calcWeights( int nFromLevel, int nToLevel,

    const tProcessParamsStub& Params )



{

    const tProcessParams& P = static_cast<const tProcessParams&>( Params );



        // Here we compute the transition weights for a geometric Brownian

        // motion process on a (possibly) non-uniform lattice,

        // where the up- resp. down-move in log space is determined

        // by \sigma_U \sqrt{dt} and \sigma_D \sqrt{dt}.



    double gVol2 = P.m_gVol * P.m_gVol;

    int nLevel = nFromLevel; 



        // The economic parameters in the Params argument hold for

        // all levels from nFromLevel to nToLevel. Since the lattice

        // might be non-uniform, however, we might have to compute

        // more than one set of weights. Within "regions", the lattice

        // is uniform.



    while( nLevel <= nToLevel ) {

        tGeoSpaceAxis::tRegion& R = axis().region( nLevel );



            // We have to compute the weights for the equation

            //

            //   W[i] = D V[i-1] + E V[i] + F V[i+1]

            //

            // which arises in the explicit scheme. Here, W represents

            // the new value, V the old values.



        double D = R.m_gDownProbA * gVol2 + R.m_gDownProbB * P.m_gDrift;

        double F = R.m_gUpProbA * gVol2 + R.m_gUpProbB * P.m_gDrift;



        D *= relDuration();

        F *= relDuration();



        double E = 1 - D - F;



        D *= P.m_gCCDiscount;

        E *= P.m_gCCDiscount;

        F *= P.m_gCCDiscount;



        int nTo = R.m_nToLevel;

        if( R.m_nFromLevel > nTo )

            nTo = R.m_nFromLevel;



        do {

            tRBWeights& W = RBWeights( nLevel );



            W.m_gLastD = D;

            W.m_gLastU = F;

            W.m_gLastM = E;



            ++nLevel;

        } while( nLevel <= nToLevel && nLevel <= nTo );

    }

}





//

//   a d j u s t Z e r o G a m m a U p B o u n d a r y

//



void tGeoExplicit::adjustZeroGammaUpBoundary( int nLevel,

    tRBWeights& RBWeights, tZGWeights& ZGWeights )



{

        // In the explicit scheme, only xGivenValue boundary types

        // are supposed to be used.

    throw tException( INTERNAL_ERROR );

}





//

//   a d j u s t Z e r o G a m m a D o w n B o u n d a r y

//



void tGeoExplicit::adjustZeroGammaDownBoundary( int nLevel,

    tRBWeights& RBWeights, tZGWeights& ZGWeights )



{

    throw tException( INTERNAL_ERROR );

}





//

//   t G e o E x p l i c i t

//



tGeoExplicit::tGeoExplicit( tGeoSpaceAxis* pAxis )

    : super( pAxis->m_nRootLevel, pAxis->m_nNumOfUpLevels,

             pAxis->m_nNumOfDownLevels ),

      tGeoSolver( pAxis )  



{

    init();

}





//

//   t G e o E x p l i c i t

//



tGeoExplicit::tGeoExplicit( const tGeoExplicit& Exmplicit )



{

    init();

    copyFrom( Exmplicit );

}





//

//   ~ t G e o E x p l i c i t

//



tGeoExplicit::~tGeoExplicit()



{

}





//

//   o p e r a t o r =

//



tGeoExplicit& tGeoExplicit::operator=( const tGeoExplicit& Explicit )



{

    if( this != &Explicit )

        copyFrom( Explicit );

    return *this;

}





//

//   c o p y F r o m

//



void tGeoExplicit::copyFrom( const tGeoExplicit& Explicit )



{

    if( this == &Explicit )

        return;



    super::copyFrom( Explicit );

    tGeoSolver::copyFrom( Explicit );

}





//

//   p r e p a r e

//



void tGeoExplicit::prepare( tOFEngine& Engine, tSlotLayer& Layer,

     int nNumOfUpLevels, int nNumOfDownLevels,

     int nLastNumOfUpLevels, int nLastNumOfDownLevels )



{

        // Extrapolate first, then call prepare() of the superclass!



    if( nNumOfDownLevels == nLastNumOfDownLevels )

        extrapolateDownBoundary( Engine, Layer, -nNumOfDownLevels );

    if( nNumOfUpLevels == nLastNumOfUpLevels )

        extrapolateUpBoundary( Engine, Layer, nNumOfUpLevels );



    super::prepare( Engine, Layer, nNumOfUpLevels, nNumOfDownLevels,

        nLastNumOfUpLevels, nLastNumOfDownLevels );

}



MTG_END_NAMESPACE