// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_HJMGAUSSIAN_MODEL_)

#define _MTG_HJMGAUSSIAN_MODEL_



#include "MtgHeap2.h"

#include "MtgHJMTermStruct.h"

#include "MtgMCEngine.h"

#include "MtgModel.h"



MTG_BEGIN_NAMESPACE



class tBootstrap;

class tDrift;

class tParser;





//

//   t H J M G a u s s i a n M o d e l

//



class tHJMGaussianModel : public tModel {



    typedef tModel super;



public:



        // evolution class for HJM gaussian model:



    class tEvolution :

        public tMCEngine::tEvolutionStub

        /* public tHJMTermStruct::tEvolutionStub */ {



            // This proxy class turns out to be necessary, for

            // multiple inheritance leads to a compiler bug

            // under Visual C++ 5.0.



        struct tProxy : public tHJMTermStruct::tEvolutionStub {

            tEvolution* m_pParent;



            tProxy() {}



            void init( const tHJMTermStruct& HJM, int nNumOfSamples, 

                const tHeap<tHJMTermStruct::tSample>& Initial ) {

                m_pParent->init( HJM, nNumOfSamples, Initial );

            }



            tRetCode progress( int nStep, int nNumOfSamples,

                const tHeap<tHJMTermStruct::tSample>& Initial,

                const tHeap<tHJMTermStruct::tSample>& Last,

                tHeap<tHJMTermStruct::tSample>& Future ) {

                return m_pParent->progress( nStep, nNumOfSamples,

                    Initial, Last, Future );

            }

        } m_Proxy;



        const tHJMGaussianModel& m_Model;

        const tPathSpace& m_PathSpace;



            // instantation means selecion of factors:



        tHeap<int> m_FactorSelect;



            // temporary helper variables

            

        tHeap2<double> m_M;

        tHeap2<double> m_S;



            // m_M and m_S need to be initialized only once:



        bool m_bInitialized;



    public:



        tEvolution( const tHJMGaussianModel& Model,

            const tPathSpace& PathSpace );



        tRetCode prepare();



        void setInstantiation( int nInstantiation );



        void init( const tHJMTermStruct& HJM, int nNumOfSamples, 

            const tHeap<tHJMTermStruct::tSample>& Initial );



        tRetCode progress( int nStep, int nNumOfSamples,

            const tHeap<tHJMTermStruct::tSample>& Initial,

            const tHeap<tHJMTermStruct::tSample>& Last,

            tHeap<tHJMTermStruct::tSample>& Future );



            // simulate a cross cast:



        tHJMTermStruct::tEvolutionStub& proxy() {

            return m_Proxy;

        }

    };



private:



    struct tFactorParam {

        tHeap<double> m_Sigma;

        tHeap<double> m_Kappa;

    };



    tBootstrap* m_pInitialBoot;  // reference

    tDrift* m_pInitialDrift;     // reference



    double m_gConstInitial;



        // The pointers to the factors themselves (i.e., the

        // factor names) are contained in the super class.



    tHeap<tFactorParam*> m_FactorParam;



    void init();

    void cleanup();



    void copyFrom( const tHJMGaussianModel& Model );



    tRetCode parseFactor( tParser& Parser, tParseInfoStub& Info );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



    friend class tEvolution;



public:



    tHJMGaussianModel();

    tHJMGaussianModel( const tHJMGaussianModel& Model );



    ~tHJMGaussianModel();



    tHJMGaussianModel& operator=( const tHJMGaussianModel& Model );



    tObject* clone() const;



    tRetCode createEngine( tMCEngine*& pEngine );



    tRetCode finalize();



        // functions used by the HJM engine:



    tRetCode loadInitial( tHJMTermStruct& TermStruct,

        int nNumOfSamples ) const;



        // functions used by the MC engine:



    int numOfInstantiations() const;

    void setInstantiation( tHeap<int>& Select, int nInstantiation ) const;



    tRetCode createEvolution( const tPathSpace& PathSpace,

        tMCEngine::tEvolutionStub*& pEvolution ) const;



        // output helper routines:



    tRetCode saveWeightsHeader( ostream& Out ) const;

    tRetCode saveWeightsData( ostream& Out, tHeap<int> Select ) const;

};



MTG_END_NAMESPACE



#endif



