// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_HTTP_DETOUR_)

#define _MTG_HTTP_DETOUR_



#include "MtgSocket.h"



MTG_BEGIN_NAMESPACE





//

//   t H t t p D e t o u r

//



class tHttpDetour {



    char m_sToken[128];

    int m_nTag;

    int m_nSeq;

    int m_nProt;



    char* m_sContent;

    int m_nContentHiwater;

    int m_nContentLength;   // parameters of current header



    char* m_sResponse;

    int m_nResponseHiwater;

    int m_nResponseLength;  // parameters of pending response



    static const int m_nTimeout;



    bool getLine( char* sCurrent, char*& sNext );

    bool getToken( const char*& sLine );



    bool getKeyword( const char*& sLine, const char* sExpect );

    bool getNumber( const char*& sLine, int& nNumber );



    tRetCode processHttpHeader( char* sHeader );



    tRetCode getHttpHeader( tSocket& Sock );

    tRetCode getHttpBody( tSocket& Sock );

    tRetCode getHttpRequest( tSocket& Sock );



    tRetCode receive( tSocket& NativeSock, bool& bStop );



    tRetCode accept( tSocket& OutSock, tSocket& NativeSock );

    tRetCode response( tSocket& OutSock, tSocket& HttpSock );



    tRetCode open( tSocket& OrgSock, tSocket& HttpSock,

        tSocket& NativeSock, int nNativePort );



    friend class tAccept;



public:



        // These objects are used only once and cannot be

        // copied. There are no copy constructors.

        // All member variables are used only for internal

        // temporary purposes.



    tHttpDetour();

    ~tHttpDetour();



        // OrgSock will be closed when run() returns, no matter what.



    tRetCode run( tSocket& OrgSock, int nNativePort );

};



MTG_END_NAMESPACE



#endif

