// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_IMAGE_INSTANCE_)

#define _MTG_IMAGE_INSTANCE_



#include "MtgHeap.h"

#include "MtgColor.h"

#include "MtgDateBase.h"

#include "MtgDateFormat.h"



extern "C" {

    #include <gd.h>

}



MTG_BEGIN_NAMESPACE



class tCurveInstance;

class tFileName;

class tImage;





//

//   t I m a g e I n s t a n c e

//



class tImageInstance : public tDateBase {



    struct tXTick {

        int m_nX;

        tDate m_Date;



        tXTick() {}

        tXTick( int x, tDate Date ) {

            m_nX = x;

            m_Date = Date;

        }

    };



        // The image which created the instance:

        

    const tImage& m_Image;



        // The pointer to the GD structure, and evt. a brush.



    gdImagePtr m_pGD;

    gdImagePtr m_pBrush;



    gdFontPtr m_pTitleFont;

    gdFontPtr m_pAxisFont;



        // These are GD colors, not tColor's.



    int m_nBgColor;     // the plot background

    int m_nTextColor;   // title and tics

    int m_nAxisColor;   // both axes and ticmarks

    int m_nGridColor;   // horizontal and vertical grid lines

    int m_nHiliteColor; // vertical gridlines marking maturities



    FILE* m_pOutFile;   // GD needs FILE instead of streams



        // Coordinates:



    int m_nTopMargin;   // margins around the plot area, depending

    int m_nBottomMargin;// on the font size 

    int m_nLeftMargin;

    int m_nRightMargin;



    int m_nPlotOrgX;    // the area where the data goes

    int m_nPlotOrgY;

    int m_nPlotWidth;

    int m_nPlotHeight;



        // Tick marks:



    int m_nNumOfTicksY;

    double m_gStepY;



    tHeap<tXTick> m_XTick;

    double m_gStepX;



        // Format for tick labels:



    tDateFormat m_LeftFormat;

    tDateFormat m_MidFormat;

    tDateFormat m_RightFormat;



        // The curve data must be registered before save() can be

        // called. Note that the drift data need not be registered,

        // as it does not change.



    tHeap<const tCurveInstance*> m_Curve;



        // Data statistics:



    double m_gDataMinY;

    double m_gDataMaxY;

    double m_gDataHeight;

    double m_gDuration; // this is a day count fraction



    tRetCode initGD( const tFileName& OutFile );

    void cleanupGD();



    void fillBrush( tColor Color );



    tRetCode analyzeExtentX();

    tRetCode analyzeExtentY();

    tRetCode analyzeData();



    void widenDataRange();



    int xlatX( double gDataX, bool bAdjust = true ) const;

    int xlatY( double gDataY, bool bAdjust = true ) const;



    void putVertical( int x, int nColor );

    void putVertical( double gFraction, int nColor );

    void putVertical( tDate Date, int nColor );



    void putTick( const char* sText, int x, int nColor,

        int& nFrom, int& nTo );



    void putTickIf( const char* sText, int x, int nColor,

        int& nLeft, int nRight );



    tRetCode doTitle();

    tRetCode doBox();

    tRetCode doTicksY();

    tRetCode doTicksX();

    tRetCode doGrid();

    tRetCode doData();



        // Image instances cannot be copied; they exist only

        // for a unique drawing.



    tImageInstance( const tImageInstance& II )

        : m_Image( II.m_Image ) {

        throw tException( INTERNAL_ERROR );

    }



public:



    tImageInstance( const tImage& Image );



    ~tImageInstance();



    const tImage& Image() const {

        return m_Image;

    }



        // Re-establish the connection between actual curves

        // and the graphics attributes in the image object.



    void registerData( const tCurveInstance* pCurve, int nTag );

    void registerData( const tCurveInstance& Curve, int nTag ) {

        registerData( &Curve, nTag );

    }



    tRetCode save( const tFileName& OutFile );

    tRetCode save();

};



MTG_END_NAMESPACE



#endif

