// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgJobServer.h"

#include "MtgJobPipe.h"

#include "MtgJobPool.h"

#include "MtgLog.h"



MTG_BEGIN_NAMESPACE





//

//   c o n s t a n t s

//



const char* tJobServer::m_sStdPipeName = "\\\\.\\pipe\\Mtg";



const int tJobServer::m_nStdNumOfPipes = 2;

const int tJobServer::m_nStdNumOfJobs = 2;





//

//   c l e a r P i p e s

//



void tJobServer::clearPipes()



{

    for( int i = 0; i < m_JobPipe.numOfElems(); ++i ) {

            // the pipes will delete themselves

        m_JobPipe[i]->die();

    }

    m_JobPipe.reset();

}





//

//   s t a r t P i p e s

//



tRetCode tJobServer::startPipes()



{

    MTG_ASSERT( m_pJobPool != 0 );



    tRetCode nRet;



    clearPipes();

    for( int i = 0; i < m_nNumOfPipes; ++i ) {

        m_JobPipe.append( new tJobPipe( m_pJobPool ) );



        if( m_sPipeName != 0 )

            m_JobPipe.last()->setName( m_sPipeName );

        if( m_pLog != 0 )

            m_JobPipe.last()->setLog( m_pLog );



        if( ( nRet = m_JobPipe.last()->start() ) != OK ) {

            clearPipes();

            return nRet;

        }

    }



    return OK;

}





//

//   t S e r v e r

//



tJobServer::tJobServer()



{

    m_pJobPool = 0;

    m_sPipeName = StrCopy( m_sStdPipeName );

    m_nNumOfPipes = m_nStdNumOfPipes;

    m_nNumOfJobs = m_nStdNumOfJobs;

    m_pLog = 0;

}





//

//   ~ t S e r v e r

//



tJobServer::~tJobServer()



{

    stop();

    if( m_sPipeName != 0 )

        delete m_sPipeName;

}





//

//   s e t P i p e N a m e

//



void tJobServer::setPipeName( const char* sPipeName )



{

    MTG_ASSERT( m_JobPipe.numOfElems() == 0 );



    if( m_sPipeName != 0 )

        delete m_sPipeName;

    m_sPipeName = StrCopy( sPipeName );

}





//

//   s e t N u m O f P i p e s

//



void tJobServer::setNumOfPipes( int nNumOfPipes )



{

    MTG_ASSERT( m_JobPipe.numOfElems() == 0 );

    m_nNumOfPipes = nNumOfPipes;

}





//

//   s e t N u m O f J o b s

//



void tJobServer::setNumOfJobs( int nNumOfJobs )



{

    MTG_ASSERT( m_pJobPool == 0 );

    m_nNumOfJobs = nNumOfJobs;

}





//

//   s e t L o g

//



void tJobServer::setLog( tLog* pLog )



{

    m_pLog = pLog;

}





//

//   u s e A r g s

//



tRetCode tJobServer::useArgs( int& argc, const char* argv[] )



{

    for( int k = 1; k < argc - 1; ++k ) {

    }



        // Remove used arguments.



    int j = 1;

    for( MTG_FOR_INIT( int ) k = 1; k < argc; ++k ) {

        if( argv[k] != 0 )

            argv[j++] = argv[k];

    }

    argc = j;



    return OK;

}





//

//   s t a r t

//



tRetCode tJobServer::start()



{

    tRetCode nRet;



    stop();



    m_pJobPool = new tJobPool( m_nNumOfJobs );



    if( ( nRet = startPipes() ) != OK ) {

        printf( "*** Unable to create pipes (ignore on Win98)\n\n" );

        m_pJobPool->die();

        m_pJobPool = 0;

        return nRet;

    }



    printf( "Accepting jobs at pipes\n\n" );

    if( m_pLog != 0 )

        m_pLog->putNormal( "--- Accepting jobs at pipes --- " );



    return OK;

}





//

//   s t o p

//



void tJobServer::stop()



{

    clearPipes();

    if( m_pJobPool != 0 ) {

        m_pJobPool->die();

        m_pJobPool = 0;

    }

}





//

//   s u b m i t

//



tRetCode tJobServer::submit( const char* sGroup, const char* sDir,

    const char* sProgram, const char* sCmdLine )



{

    return tJobPipe::submit( sGroup, sDir, sProgram, sCmdLine );

}





//

//   s u b m i t

//



tRetCode tJobServer::submit( const char* sCmdLine )



{

    return tJobPipe::submit( sCmdLine );

}



MTG_END_NAMESPACE

