// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_JOB_SERVER_)

#define _MTG_JOB_SERVER_



#include "MtgHeap.h"



#if defined(_WIN32)

    #include <windows.h>

#endif



MTG_BEGIN_NAMESPACE



class tJobPool;

class tJobPipe;

class tLog;





//

//   t J o b S e r v e r

//



class tJobServer {



    tJobPool* m_pJobPool;

    tHeap<tJobPipe*> m_JobPipe;



    char* m_sPipeName;

    int m_nNumOfPipes;

    int m_nNumOfJobs;



    tLog* m_pLog;



    static const char* m_sStdPipeName;

    static const int m_nStdNumOfPipes;

    static const int m_nStdNumOfJobs;



    void clearPipes();

    tRetCode startPipes();



        // Server objects are unique, they cannot be copied.



    tJobServer( const tJobServer& ) {

        throw tException( INTERNAL_ERROR );

    }



public:



    tJobServer();

    ~tJobServer();



    void setPipeName( const char* sPipeName );

    void setNumOfPipes( int nNumOfPipes );

    void setNumOfJobs( int nNumOfJobs );



    void setLog( tLog* pLog );

    void setLog( tLog &Log ) {

        setLog( &Log );

    }



    tRetCode useArgs( int& argc, const char* argv[] );



    tRetCode start();

    void stop();



        // Service functions for the client side, to

        // obey the proper protocol:



    static tRetCode submit( const char* sGroup, const char* sDir,

        const char* sProgram, const char* sCmdLine );



    static tRetCode submit( const char* sCmdLine );

};



MTG_END_NAMESPACE



#endif

