// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_JUMP_BAG_)

#define _MTG_JUMP_BAG_



#include "MtgHeap.h"

#include "MtgSigBag.h"



MTG_BEGIN_NAMESPACE





//

//   t J u m p B a g

//



class tJumpBag {



public:



    class tRefine {            

        public:

            tRefine( const tHeap<bool>& UnderControl ) 

                : m_UnderControl( UnderControl ) {

            }



            const tHeap<bool>& m_UnderControl;

            virtual void refine( tSigBag& Approx, const tHeap<int>& Pos,

                const tSignature*& pAltSig, bool bFirst ) = 0;

    };



private:



    struct tNode {

        bool m_bRefined;

        bool m_bMarked;

        tSigBag m_Approx;

        tSigBag m_Control;

    };



    const tSignature* m_pRefSig;



    int m_nCoord;       // on which coordinate lies the line?

    int m_nLeft;        // what is the leftmost value of that coordinate?                                                   

    int m_nRight;       // what is the rightmost value of that coordinate?

    int m_nSkip;        // skip how many on the left side?



    bool m_bUseControl;



    tNode* m_Node;

    int m_nNumOfNodes;

    int m_nUsedNodes;



        // Temporary variables, not to be copied:



    tHeap<int> m_Pos;



    tSignature m_JumpSig[2];



    int m_nLeftJumpSig;

    bool m_bLeftJump;



    int m_nRightJumpSig;

    bool m_bRightJump;



    bool m_bForward;

    int m_nBacktrack;



    int m_nCurNode;



        // Some helper functions.



    void init();

    void cleanup();



    bool beginRefine( bool bPreRefined );

    void endRefine( tRefine& Ref, bool bPreRefined );



    bool findJumps();



    bool compare( const tSignature* pAltSig,

        const tSignature& LayerSig, tRefine& Ref );



    void advance( bool bNoAction );



public:



    tJumpBag();

    tJumpBag( const tJumpBag& Bag );



    ~tJumpBag();



    tJumpBag& operator=( const tJumpBag& Bag );



    void copyFrom( const tJumpBag& Bag );



    void setRefSignature( const tSignature* pSig );



        // Use instead of reset():



    void setCoord( int nCoord, int nLeft, int nRight,

        bool bUseControl = false );



    void restart();

    void shrink( int nLeft, int nRight );



    void hideMayExAlternatives( bool bUnderControl );

    void showMayExAlternatives( bool bUnderControl );



    tSigBag& approxSigBag( int nPos ) {

        MTG_ASSERT( nPos >= m_nLeft && nPos - m_nLeft < m_nNumOfNodes );            

        return m_Node[nPos - m_nLeft].m_Approx;

    }



    tSigBag& approxSigBag( const tHeap<int>& Pos ) {

        return approxSigBag( Pos[m_nCoord] );

    }



    tSigBag& controlSigBag( int nPos ) {

        MTG_ASSERT( nPos >= m_nLeft && nPos - m_nLeft < m_nNumOfNodes );

        return m_Node[nPos - m_nLeft].m_Control;

    }



    tSigBag& controlSigBag( const tHeap<int>& Pos ) {

        return controlSigBag( Pos[m_nCoord] );

    }



    void refine( tRefine& Ref, bool bPreRefined );

};



MTG_END_NAMESPACE



#endif

