// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_LOG_)

#define _MTG_LOG_



MTG_BEGIN_NAMESPACE



class tJobPipe;

class tSocket;





//

//   t L o g

//



class tLog {



    char* m_sFileName;

    FILE* m_fFile;



#if defined(_WIN32)

    long m_nLock;

#endif



    void init();



    void lock();

    void unlock();



    bool beginPut( bool bNormal );

    void putSocket( const tSocket& Sock );

    void putJobPipe( const tJobPipe& JobPipe );

    void endPut();



        // No copying is allowed for logs, so the copy constructor

        // and the assignment operator are private.



    tLog( const tLog& Log ) {

        throw tException( INTERNAL_ERROR );

    }



    tLog& operator=( const tLog& Log ) {

        throw tException( INTERNAL_ERROR );

        return *this;

    }



public:



    tLog();

    tLog( const char* sFileName );



    ~tLog();



        // Not threadsafe:



    tRetCode useArgs( int& argc, const char* argv[] );



    void setFileName( const char* sFileName );



    tRetCode open();

    tRetCode open( const char* sFileName );



    void close();



    const char* fileName() const { return m_sFileName; }



        // Threadsafe:



    void putNormal( const char* sFmt, ... );

    void putNormal1( const char* sFmt, va_list Marker );



    void putError( const char* sFmt, ... );

    void putError1( const char* sFmt, va_list Marker );



    void putNormal( const tSocket& Sock, const char* sFmt, ... );

    void putNormal1( const tSocket& Sock, const char* sFmt, va_list Marker );



    void putError( const tSocket& Sock, const char* sFmt, ... );

    void putError1( const tSocket& Sock, const char* sFmt, va_list Marker );



    void putNormal( const tJobPipe& JobPipe, const char* sFmt, ... );

    void putNormal1( const tJobPipe& JobPipe,

        const char* sFmt, va_list Marker );



    void putError( const tJobPipe& JobPipe, const char* sFmt, ... );

    void putError1( const tJobPipe& JobPipe,

        const char* sFmt, va_list Marker );

};



MTG_END_NAMESPACE



#endif

