// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_LOOKUP_)

#define _MTG_LOOKUP_



#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE



// The mapping is done by using a hash table whose size grows as more

// entries are added. Deletion is not supported. The hash table is

// always less than 50% full; quadratic hashing is used. It is thus

// guaranteed that there is always a free entry available.





//

//   t L o o k u p

//



template <class T>

class tLookup {



    struct tEntry {

        char* m_sId;

        T m_Data;

    };        



    tEntry *m_aHash;

    int m_nHashSize;

    int m_nNumOfEntries;



    void init();



    void growHash();



    int hash( const char *sId ) const;

    int find( const char *sId ) const;



public:



    tLookup();

    tLookup( const tLookup& Lookup );



    ~tLookup();



    void reset();

    void clear();



    tLookup& operator=( const tLookup& Lookup );



    void copyFrom( const tLookup& Lookup );

        

    tRetCode insert( const char* sId, T& Data );

    tRetCode replace( const char* sId, T& Data );

    tRetCode retrieve( const char* sId, T& Data ) const;



    int numOfEntries() const {

        return m_nNumOfEntries;

    }

};



MTG_END_NAMESPACE



#if ! defined(_MTG_LOOKUP_BODY_)

    #define _MTG_LOOKUP_HEADER_

    #if defined(_WIN32)

        #include "MtgLookup.cpp"

    #else   

        #include "MtgLookup.C"

    #endif

    #undef _MTG_LOOKUP_HEADER_

#endif



#endif

