// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_MCOPT_INSTANCE_)

#define _MTG_MCOPT_INSTANCE_



#include "MtgOptInstance.h"

#include "MtgHeap.h"

#include "MtgHeap2.h"



MTG_BEGIN_NAMESPACE



class tMCEngine;





//

//   t M C O p t I n s t a n c e

//



class tMCOptInstance : public tOptInstance {



    typedef tOptInstance super;



private:



        // The m_pValue matrix is the input to the optimizer.

        // The last column in *m_pValue represents fixed

        // cashflows resulting from non-priced instruments

        // in the portfolio. All other columns represent

        // unit-values of priced instruments.



    const tHeap2<double>* m_pValue;



protected:



        // These are the weigths for individual paths:



    tHeap<double> m_Weight;



    const tHeap2<double>& value() const {

        MTG_ASSERT( m_pValue != 0 );

        return *m_pValue;

    }



        // The work is done here:



    virtual tRetCode minimize( double& gTotal ) = 0;



public:



    tMCOptInstance( const tOptimizer& Optimizer, tMCEngine& Engine );



    ~tMCOptInstance();



        // prepare() must be called by the engine at the

        // right time, followed by run().



    tRetCode prepare( const tHeap2<double>& Value,

        const tPortfolio& Portfolio );



    tRetCode run( const tHeap2<double>& Value,

        const tPortfolio& Portfolio, double& gTotal );



    tRetCode run( double& gTotal );



        // read from engine:



    const tHeap<double>& weight() {

        return m_Weight;

    }

};



MTG_END_NAMESPACE



#endif

