// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_MINIMIZER_)

#define _MTG_MINIMIZER_



#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE





//

//   t M i n i m i z e r

//



class tMinimizer {



        // This minimizer is based on BFGS.



        // Numerical tolerance. Default: 1e-6.



    double m_gTolerance;



        // Print progress report while optimizing?

        // Default: on for Debug, off for Release.



    bool m_bVerbose;



        // The result is put here:



    double m_gResult;



protected:



    void copyFrom( const tMinimizer& Minimizer );



        // eval() must take Lambda as input and compute

        // gValue and Gradient. If anything goes wrong,

        // this function must terminate with an exception.



    virtual void eval( const tHeap<double>& Lambda,

        double& gValue, tHeap<double>& Gradient ) = 0;



public:



    tMinimizer();

    tMinimizer( const tMinimizer& Minimizer );



    ~tMinimizer();



    void setTolerance( double gTolerance = 1e-6 );

    void setVerbose( bool bVerbose = true );



        // minimize() takes LoBound and HiBound as input and

        // computes Lambda, Gradient and gValue.



    void minimize( const tHeap<double>& LoBound, 

        const tHeap<double>& HiBound,

        tHeap<double>& Lambda, tHeap<double>& Gradient );



    void minimize( double gLoBound, double gHiBound,

        tHeap<double>& Lambda, tHeap<double>& Gradient );



    void minimize( const tHeap<double>& LoBound, 

        const tHeap<double>& HiBound, tHeap<double>& Lambda );



    void minimize( double gLoBound, double gHiBound,

        tHeap<double>& Lambda );



        // The result itself is often uninteresting.

        // For that reason, it must be retrieved explicitely:



    double result() const {

        return m_gResult;

    }

};



MTG_END_NAMESPACE



#endif

