// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgMisc.h"



#if defined(_WIN32)

    #include <windows.h>

    #include <direct.h>

#endif



#if ! defined(_MAX_PATH)

    #define _MAX_PATH 256

#endif



MTG_BEGIN_NAMESPACE





//

//   I s P r i m e

//



bool IsPrime( int p )



{

    int k, k2;



    MTG_ASSERT( p % 2 == 1 );



    k = 3;

    k2 = 9;



    while( k2 <= p ) {

        if( p % k == 0 )

            return false;

        k2 += k + k + 1;

        ++k;

    }



    return true;

}





//

//   N e x t P r i m e

//



int NextPrime( int p )



{

    if( p < 3 )

        p = 3;

    else

        if( p % 2 == 0 )

            ++p;



    while( ! IsPrime( p ) )

        p += 2;



    return p;

}





//

//   S t r C o p y

//



char* StrCopy( const char* s )



{

    if( s == 0 )

        return 0;

    char* q = new char[strlen( s ) + 1];

    strcpy( q, s );

    return q;

}





//

//   S t r T o L o w e r

//



char* StrToLower( const char* s )



{

    char* q = StrCopy( s );



    if( q ) {

        for( char* p = q; *p; ++p )

            *p = tolower( *p );

    }

    return q;

}





//

//   G e t D i r

//



char* GetDir()



{

    char* s = new char[_MAX_PATH];



    if( getcwd( s, _MAX_PATH ) == 0 ) {

        delete s;

        return 0;

    }

    return s;

}





//

//   S e t D i r

//



void SetDir( const char* sDir )



{

    if( sDir != 0 )

        chdir( sDir );

}





//

//   C h T o P r o g r a m D i r

//



void ChToProgramDir( const char* sExecutable )



{

    char sPath[512];



#if defined(_WIN32)



    int l = GetModuleFileName( NULL, sPath, sizeof(sPath) );



    if( l == 0 )

        return;



#else



    if( sExecutable == 0 )

        return;



    size_t l = strlen( sExecutable );



    if( l >= sizeof(sPath) ) {

        l = sizeof(sPath) - 1;

        memcpy( sPath, sExecutable, l );

        sPath[l] = 0;

    }

    else {

        strcpy( sPath, sExecutable );

    }



#endif



        // Truncate file name.



    while( l > 0 &&

            ( sPath[l - 1] != '\\' &&

              sPath[l - 1] != '/' &&

              sPath[l - 1] != ':' ) )  {

        --l;

    }



    if( l > 0 )

        sPath[l - 1] = 0;



    chdir( sPath );

}





//

//   S e c s O f D a y

//



long SecsOfDay()



{

    time_t T;

    struct tm *M;



    time( &T );

    if( ( M = localtime( &T ) ) != 0 )

        return M->tm_hour * 3600L + M->tm_min * 60L + M->tm_sec;

    return 0;

}





//

//   W a i t F o r

//



void WaitFor( long nSecs )



{

#if defined(_WIN32)

    Sleep( (DWORD) nSecs * 1000 );

#else

    sleep( nSecs );

#endif

}





//

//   W a i t U n t i l

//



void WaitUntil( long nSecs )



{

    time_t T;

    struct tm *M;



    time( &T );

    if( ( M = localtime( &T ) ) != 0 ) {

        long n = M->tm_hour * 3600L + M->tm_min * 60L + M->tm_sec;



        nSecs %= 3600L * 24L;

        if( n > nSecs )

            nSecs += 3600L * 24L;

        WaitFor( nSecs - n );

    }

}





//

//   O p e n W r i t e

//



tRetCode OpenWrite( ofstream& Out, const char* sFileName )



{

        // Try to open the file 3 times, in 1 second intervals.

        // Someone else might be sharing the file, and we want

        // it exclusively.



    for( int k = 0; k < 3 && ! Out.is_open(); ++k ) {

        if( k > 0 )

            WaitFor( 1 );

        Out.open( sFileName, ios::out, filebuf::sh_none );

    }



    return Out.is_open() ? OK : WRITE_ERROR;

}





//

//   W r i t e B a n n e r

//



tRetCode WriteBanner( ofstream& Out, const char* sText )



{

    time_t t = time( NULL );

    struct tm T = *localtime( &t );



    char c = Out.fill( '0' );

    int w = Out.width( 2 );



    Out << "// " << tDate( T )

        << " " << T.tm_hour

        << ":" << T.tm_min

        << ":" << T.tm_sec;



    Out.fill( c );

    Out.width( w );



    if( sText != 0 )

        Out << " " << sText;

    Out << endl;



    return Out.good() ? OK : WRITE_ERROR;

}



MTG_END_NAMESPACE

