// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_MISC_)

#define _MTG_MISC_



MTG_BEGIN_NAMESPACE



// Helper functions that don't belong to classes are collected here.

// It's an assortment of useful tools, used throughout the package.





//

//   f u n c t i o n s

//



bool IsPrime( int p );

int NextPrime( int p );



char* StrCopy( const char* s );

char* StrToLower( const char* s );



char* GetDir();

void SetDir( const char* sDir );



void ChToProgramDir( const char* sExecutable );



    // Current time in seconds of day:



long SecsOfDay();



    // Sleep for lSecs seconds:



void WaitFor( long nSecs );



    // Sleep until current time is lSecs, modulo number

    // of seconds per day.



void WaitUntil( long nSecs );



    // Opens the file for exclusive write:



tRetCode OpenWrite( ofstream& Out, const char* sFileName );



    // Write a banner line to the stream:



tRetCode WriteBanner( ofstream& Out, const char* sText = 0 );



MTG_END_NAMESPACE



#endif

