// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_MODEL_)

#define _MTG_MODEL_



#include "MtgFileName.h"

#include "MtgHeap.h"

#include "MtgObject.h"

#include "MtgMCEngine.h"



MTG_BEGIN_NAMESPACE



class tCalendar;

class tFactor;

class tFDEngine;

class tParser;

class tSpaceAxis;

class tPathSpace;

class tPortfolio;

class tScenario;





//

//   t M o d e l

//



class tModel : public tObject {



    typedef tObject super;



        // Collects all the factors. upRef() and downRef() 

        // are called when the pointers are set/reset.

        // To make sure this is done consistently, derived

        // classes must call a function to insert new factors.



    tHeap<tFactor*> m_Factor;



    bool m_bHasWeights;         // are there individual weigths

                                // per instantiation?

    tHeap<double> m_Weight;     // if yes, they are here!

    tFileName m_WeightFile;     // ...loaded from here

    double m_gGlobalWeight;     // otherwise, this is just 1/number of

                                // instantiations



    void init();



    tRetCode loadWeights();

    void normalizeWeights();



protected:



    struct tParseInfo : super::tParseInfoStub {

        bool m_bParam1;

        bool m_bParam2;

    };



    tCalendar* m_pCalendar; // referenced



    void copyFrom( const tModel& Model );



    tRetCode appendFactor( tFactor* pFactor );



    tRetCode parsePrefix( tParser& Parser, tParseInfoStub& Info );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



public:



    tModel();

    tModel( const tModel& Model );



    ~tModel();



    tRetCode finalize();



    int numOfFactors() const {

        return m_Factor.numOfElems();

    }



    const tFactor* factor( int nPos ) const {

        return m_Factor[nPos];

    }



    tRetCode matchFactors( const tHeap<tFactor*>& Mirror,

        tHeap<int>& Xlat ) const;



    double dayUnit() const;



        // FUNCTIONS FOR FINITE DIFFERENCE METHODS:



        // Create FD engine:



    virtual tRetCode createEngine( const tScenario* pScenario,

        tFDEngine*& pEngine, tAccuracy m_nAccuracy ) {

        return NOT_AVAILABLE;

    }



        // Subsequently, create space axis:

        

    virtual tRetCode createSpaceAxis( tFDMethod nMethod, double gMaxDt,

        tHeap<tSpaceAxis*>& Space, const tPortfolio* pPf = 0 ) {

        throw tException( NOT_AVAILABLE );

        return NOT_AVAILABLE;   // for the compiler

    }



        // During runtime, call this function:



    virtual bool isLinear( int nDay ) const {

        throw tException( NOT_AVAILABLE );

        return false;           // for the compiler

    }



        // FUNCTIONS FOR MONTE CARLO METHODS:



        // Create MC engine:



    virtual tRetCode createEngine( tMCEngine*& pEngine ) {

        return NOT_AVAILABLE;

    }



        // Find out how many instantiations there are (degree

        // of uncertainty):



    virtual int numOfInstantiations() const {

        return 1;

    }



    virtual void setInstantiation( tHeap<int>& Select,

        int nInstantiation ) const;



        // Subsequently, create path evolution object (which converts

        // the Brownian motion path into the diffusion):



    virtual tRetCode createEvolution( const tPathSpace& PathSpace,

        tMCEngine::tEvolutionStub*& pEvolution ) const {

        throw tException( NOT_AVAILABLE );

        return NOT_AVAILABLE;   // for the compiler

    }



        // Some output routines:



    virtual tRetCode saveWeightsHeader( ostream& Out ) const;

    virtual tRetCode saveWeightsData( ostream& Out, tHeap<int> Select ) const;



    tRetCode saveWeights( ostream& Out, const tHeap<double>* pWeight ) const;

    tRetCode saveWeights( ostream& Out, const tHeap<double>& Weight ) const;

    tRetCode saveWeights( ostream& Out ) const;



    tRetCode saveWeights( const tFileName& Out,

        const tHeap<double>* pWeight ) const;

    tRetCode saveWeights( const tFileName& Out,

        const tHeap<double>& Weight ) const;

    tRetCode saveWeights( const tFileName& Out ) const;



    static tRetCode parse( tParser& Parser, tSystem& System,

        tObject*& pObj );

};



MTG_END_NAMESPACE



#endif

