// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"



#define _MTG_MULTI_ARRAY_BODY_

#include "MtgMultiArray.h"

#undef _MTG_MULTI_ARRAY_BODY_



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



template <class T>

void tMultiArray<T>::init()



{

}





//

//   r e s i z e

//



template <class T>

void tMultiArray<T>::resize()



{

    int nNumOfElems = m_Bounds.dimension() == 0 ? 0 : 1;



    for( int k = 0; k < m_Bounds.dimension(); ++k )

        nNumOfElems *= m_Bounds.size( k );



    m_Data.numOfElems( nNumOfElems );

}





//

//   i t e r a t e

//



template<class T>

tRetCode tMultiArray<T>::iterate( tHeap<int>& Pos, int nDim, bool bInner,

    tIterator& Iter )



{

    int nFrom = from( nDim );

    int nTo = to( nDim );



    if( nDim == dimension() - 1 ) {

        Pos[nDim] = nFrom;

        Iter.f( *this, Pos, false );

        for( Pos[nDim] = nFrom + 1; Pos[nDim] < nTo; ++Pos[nDim] )

            Iter.f( *this, Pos, bInner );

        if( nTo > nFrom ) {

            Pos[nDim] = nTo;

            Iter.f( *this, Pos, false );

        }

    }

    else {

        Pos[nDim] = nFrom;

        iterate( Pos, nDim + 1, false, Iter );

        for( Pos[nDim] = nFrom + 1; Pos[nDim] < nTo; ++Pos[nDim] )

            iterate( Pos, nDim + 1, bInner, Iter );

        if( nTo > nFrom ) {

            Pos[nDim] = nTo;

            iterate( Pos, nDim + 1, false, Iter );

        }

    }



    return OK;

}





//

//   t M u l t i A r r a y

//



template <class T>

tMultiArray<T>::tMultiArray()



{

    init();

}





//

//   t M u l t i A r r a y

//



template <class T>

tMultiArray<T>::tMultiArray( const tMultiArray<T>& Array )



{

    init();

    copyFrom( Array );

}





//

//   t M u l t i A r r a y

//



template <class T>

tMultiArray<T>::tMultiArray( const tArrayBounds& Bounds )



{

    init();

    setBounds( Bounds );

}





//

//   ~ t M u l t i A r r a y

//



template <class T>

tMultiArray<T>::~tMultiArray()



{

    reset();

}





//

//   r e s e t

//



template <class T>

void tMultiArray<T>::reset()



{

    m_Bounds.reset();

    m_Data.clear();

}





//

//   o p e r a t o r =

//



template <class T>

tMultiArray<T>& tMultiArray<T>::operator=( const tMultiArray<T>& Array )



{

    if( &Array != this )

        copyFrom( Array );

    return *this;

}





//

//   c o p y F r o m

//



template <class T>

void tMultiArray<T>::copyFrom( const tMultiArray<T>& Array )



{

    if( &Array == this )

        return;



    reset();



    m_Bounds = Array.m_Bounds;

    m_Data = Array.m_Data;

}





//

//   s e t B o u n d s

//



template <class T>

void tMultiArray<T>::setBounds( const tArrayBounds& Bounds )



{

    reset();

    m_Bounds = Bounds;

    resize();

}





//

//   s e t B o u n d s

//



template <class T>

void tMultiArray<T>::setBounds( const tArrayBounds* pBounds )



{

    MTG_ASSERT( pBounds != 0 );

    setBounds( *pBounds );

}





//

//   f i l l

//



template <class T>

void tMultiArray<T>::fill( const T& Data )



{

    m_Data.fill( Data );

}





//

//   f i l l R o w

//



template <class T>

void tMultiArray<T>::fillRow( int xn, const T& Data )



{

    MTG_ASSERT( xn >= m_Bounds.from( dimension() - 1 ) &&

                xn <= m_Bounds.to( dimension() - 1 ) );



    int n = m_Bounds.rowSize();



    for( int k = xn - m_Bounds.from( dimension() - 1 );

            k < m_Data.numOfElems(); k += n ) {

        m_Data[k] = Data;

    }

}





//

//   o p e r a t o r ( )

//



template <class T>

T& tMultiArray<T>::operator()( int x1, int x2, int x3, int x4, ... ) const



{

    va_list Marker;

    va_start( Marker, x4 );

    return m_Data[m_Bounds.pos( x1, x2, x3, x4, Marker )];

}



//

//   r o w

//



template <class T>

T* tMultiArray<T>::row( int x1, int x2, int x3, int x4, ... ) const



{

    va_list Marker;

    va_start( Marker, x4 );

    return *m_Data[m_Bounds.row( x1, x2, x3, x4, Marker )];

}





//

//   i t e r a t e

//



template<class T>

tRetCode tMultiArray<T>::iterate( tIterator& Iter )



{

    tHeap<int> Pos;



    Pos.numOfElems( dimension() );

    try{ 

        iterate( Pos, 0, true, Iter );

    }

    catch( tException E ) {

        return E.ret();

    }

    return OK;

}



#if defined(_MTG_WITH_MATHLINK)



//

//   t o M a t h L i n k

//



template<class T>

tRetCode tMultiArray<T>::toMathLink( MLINK MathLink ) const



{

    int nRet;

    long* Dim = new long[dimension()];



    for( int k = 0; k < dimension(); ++k )

        Dim[k] = m_Bounds.size( k );



        // Speculate about the data type (only supported types are

        // int and double).



    if( sizeof(T) == sizeof(int) )

        nRet = MLPutIntegerArray( MathLink, (int*) &m_Data[0], Dim, 0, dimension() );

    else

        nRet = MLPutRealArray( MathLink, (double*) &m_Data[0], Dim, 0, dimension() );



    delete[] Dim;



    if( nRet == 0 )

        return MATHLINK_ERROR;

    return OK;

}



#endif



MTG_END_NAMESPACE