// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_MULTI_ARRAY_)

#define _MTG_MULTI_ARRAY_



#include "MtgArrayBounds.h"



MTG_BEGIN_NAMESPACE





//

//   t M u l t i A r r a y

//



template<class T>

class tMultiArray {



public:



    class tIterator {

    public:

            // f is expected to throw an exception if there is a problem.

        virtual void f( tMultiArray<T>& Parent, const tHeap<int>& Pos,

            bool bInner ) = 0;

    };



private:



    tArrayBounds m_Bounds;

    tHeap<T> m_Data;



    void init();

    void resize();



    tRetCode iterate( tHeap<int>& Pos, int nDim, bool bInner,

        tIterator& Iter );



public:



    tMultiArray();

    tMultiArray( const tMultiArray& Array );

    tMultiArray( const tArrayBounds& Bounds );



    ~tMultiArray();



    void reset();



    tMultiArray& operator=( const tMultiArray& Array );



    void copyFrom( const tMultiArray& Array );



    void setBounds( const tArrayBounds& Bounds );

    void setBounds( const tArrayBounds* pBounds );



    int dimension() const {

        return m_Bounds.dimension();

    }



    int from( int nDim ) const {

        return m_Bounds.from( nDim );

    }



    int to( int nDim ) const {

        return m_Bounds.to( nDim );

    }



    void fill( const T& Data );



        // The following functions fills all rows (the last

        // dimension) at relative position xn with Data.



    void fillRow( int xn, const T& Data );



    T& operator()( int x1 ) const {

        return m_Data[m_Bounds.pos( x1 )];

    }



    T& operator()( int x1, int x2 ) const {

        return m_Data[m_Bounds.pos( x1, x2 )];

    }



    T& operator()( int x1, int x2, int x3 ) const {

        return m_Data[m_Bounds.pos( x1, x2, x3 )];

    }



    T& operator()( int x1, int x2, int x3, int x4, ... ) const;



    T& operator()( const tHeap<int>& x ) const {

        return m_Data[m_Bounds.pos( x )];

    }



    T& operator()( const int x[] ) const {

        return m_Data[m_Bounds.pos( x )];

    }



    T& operator()( int x1, const tHeap<int>& x ) const {

        return m_Data[m_Bounds.pos( x1, x )];

    }



    T* row( int x1 ) const {

        return &m_Data[m_Bounds.row( x1 )];

    }



    T* row( int x1, int x2 ) const {

        return &m_Data[m_Bounds.row( x1, x2 )];

    }



    T* row( int x1, int x2, int x3 ) const {

        return &m_Data[m_Bounds.row( x1, x2, x3 )];

    }



    T* row( int x1, int x2, int x3, int x4, ... ) const;



    T* row( const tHeap<int>& x ) const {

        return &m_Data[m_Bounds.row( x )];

    }



    T* row( const int x[] ) const {

        return &m_Data[m_Bounds.row( x )];

    }



    tRetCode iterate( tIterator& Iter );



#if defined(_MTG_WITH_MATHLINK)

    tRetCode toMathLink( MLINK MathLink ) const;

#endif

};



MTG_END_NAMESPACE



#if ! defined(_MTG_MULTI_ARRAY_BODY_)

    #define _MTG_MULTI_ARRAY_HEADER_

    #if defined(_WIN32)

        #include "MtgMultiArray.cpp"

    #else   

        #include "MtgMultiArray.C"

    #endif

    #undef _MTG_MULTI_ARRAY_HEADER_

#endif



#endif

