// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgObject.h"

#include "MtgParser.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tObject::copyFrom( const tObject& Obj )



{

    if( this == &Obj )

        return;



    strcpy( m_sName, Obj.m_sName );

    m_bIsVerbose = Obj.m_bIsVerbose;

    m_bIsFinalized = Obj.m_bIsFinalized;



    super::copyFrom( Obj );

}





//

//   p a r s e T y p e

//



tRetCode tObject::parseType( tParser& Parser,

    tToken& nToken, tToken nDefault )



{

    tRetCode nRet;

    bool bGo;



    if( ( nRet = Parser.scanBeginOfObj() ) != OK )

        return nRet;



    if( Parser.endOfObj() )

        return Parser.setError( "type expected" );



    switch( Parser.curToken() ) {

        case xTokType :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;



            nToken = Parser.curToken();



            if( ( nRet = Parser.readToken() ) != OK ||

                ( nRet = Parser.swallowComma( bGo ) ) != OK ) {

                return nRet;

            }

            if( ! bGo && ! Parser.endOfObj() )

                return Parser.setError( INVALID_KEYWORD );

            break;



        default : // assume default

            nToken = nDefault;

            break;

    }



    return OK;

}





//

//   p a r s e P r e f i x

//



tRetCode tObject::parsePrefix( tParser& Parser, tParseInfoStub& Info )



{

    return OK;

}





//

//   p a r s e P a r a m

//



tRetCode tObject::parseParam( tParser& Parser, tParseInfoStub& Info )



{

    if( Parser.curToken() == xTokVerbose ) {

        if( m_bIsVerbose )

            return Parser.setError( ATTR_REDEFINITION );

        m_bIsVerbose = true;

        return Parser.readToken();

    }

    return Parser.setError( INVALID_KEYWORD );

}





//

//   p a r s e P o s t f i x

//



tRetCode tObject::parsePostfix( tParser& Parser, tParseInfoStub& Info )



{

    return OK;

}





//

//   p a r s e

//



tRetCode tObject::parse( tParser& Parser, tParseInfoStub* pInfo )



{

    bool bGo;

    tRetCode nRet;

    tParseInfoStub Info;

    

    if( pInfo == 0 )

        pInfo = &Info;



    bGo = true;

    touch();



    if( ( nRet = parsePrefix( Parser, *pInfo ) ) != OK )

        return nRet;



    while( bGo && ! Parser.endOfObj() ) {

        switch( Parser.curToken() ) {

            case xTokType :

                return Parser.setError( "type already defined" );



            default :

                if( ( nRet = parseParam( Parser, *pInfo ) ) != OK )

                    return nRet;

                break;

        }

        if( ( nRet = Parser.swallowComma( bGo ) ) != OK )

            return nRet;

    }



    if( ( nRet = Parser.scanEndOfObj() ) != OK ||

        ( nRet = parsePostfix( Parser, *pInfo ) ) != OK ) {

        return nRet;

    }



    if( ( nRet = finalize() ) != OK )

        return Parser.setError( nRet );

    

    return OK;

}





//

//   f i n a l i z e

//



tRetCode tObject::finalize()



{

    m_bIsFinalized = true;

    return OK;

}





//

//   t O b j e c t

//



tObject::tObject()



{

    m_nRefCnt = 0;

    strcpy( m_sName, "" );

    m_bIsVerbose = false;

    m_bIsFinalized = false;

}





//

//   t O b j e c t

//



tObject::tObject( const tObject& Obj )



{

    m_nRefCnt = 0;

    strcpy( m_sName, Obj.m_sName );

    m_bIsVerbose = Obj.m_bIsVerbose;

    m_bIsFinalized = Obj.m_bIsFinalized;

}





//

//   ~ t O b j e c t

//



tObject::~tObject()



{

    MTG_ASSERT( m_nRefCnt == 0 );

}





//

//   s e t N a m e

//



void tObject::setName( const char* sName )



{

    int l = strlen( sName );



    if( l >= (int) sizeof(m_sName) ) {

        memcpy( m_sName, sName, sizeof(m_sName) - 1 );

        m_sName[sizeof(m_sName) - 1] = 0;

    }

    else {

        strcpy( m_sName, sName );

    }

}





//

//   u p R e f

//



void tObject::upRef()



{

    ++m_nRefCnt;

}





//

//   d o w n R e f

//



void tObject::downRef()



{

    MTG_ASSERT( m_nRefCnt > 0 );

    --m_nRefCnt;

}





//

//   c a n D e l e t e

//



bool tObject::canDelete() const



{

    return m_nRefCnt == 0 ? true : false;

}





//

//   v e r b o s e

//



ostream& tObject::verbose() const



{

    MTG_ASSERT( m_bIsVerbose );

    return constSystem().verbose();

}





//

//   v e r b o s e

//



void tObject::verbose( const char* sFmt, ... ) const 



{

    if( m_bIsVerbose ) {

        va_list Arg;



        va_start( Arg, sFmt );

        constSystem().verboseArg( sFmt, Arg );

    }

}



MTG_END_NAMESPACE

