// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_OPT_INSTANCE_)

#define _MTG_OPT_INSTANCE_



#include "MtgHeap.h"

#include "MtgWithSystem.h"



MTG_BEGIN_NAMESPACE



class tEngine;

class tOptimizer;

class tPortfolio;





//

//   t O p t I n s t a n c e

//



class tOptInstance {



        // For preparation we need access to instruments:



    const tPortfolio* m_pPortfolio;



        // Optimizer instances cannot be copied; they exist only

        // for a unique optimization run.



    tOptInstance( const tOptInstance& OI, tEngine& ES )

        : m_Optimizer( OI.m_Optimizer ), m_Engine( ES ) {

        throw tException( INTERNAL_ERROR );

    }



protected:



        // The optimizer which created the instance:

        

    const tOptimizer& m_Optimizer;



        // The engine that works with the optimizer:



    tEngine& m_Engine;



        // These arrays are NOT indexed with instrument

        // indexes, but rather absolutely, to avoid gaps.



    tHeap<double> m_Price;

    tHeap<double> m_Lambda;

    tHeap<double> m_Gradient;



    tRetCode prepare( const tPortfolio& Portfolio );



public:



    tOptInstance( const tOptimizer& Optimizer, tEngine& Engine );



    virtual ~tOptInstance();



        // The object uses the portfolio reference to guess

        // an initial lambda vector (in prepare()), but that

        // may be corrected by calling the following function,

        // where the array is indexed by the instrument index.



    void injectMultipliers( const tHeap<double>& Multiplier );



        // After optimization, the lambdas represent different

        // multipliers for the priced instruments. Also,

        // gradient information for priced instruments is

        // available. The following functions write this

        // information back into the respective arrays,

        // which are indexed with instrument indexes.



    void extractMultipliers( tHeap<double>& Multiplier ) const;

    void extractGradient( tHeap<double>& Gradient ) const;

};



MTG_END_NAMESPACE



#endif

