// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgOptimizer.h"

#include "MtgEntropyOpt.h"

#include "MtgParser.h"

#include "MtgPathSpace.h"

#include "MtgPortfolio.h"



#include <float.h>



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tOptimizer::copyFrom( const tOptimizer& Opt )



{

    if( &Opt == this )

        return;



    m_InMultiplierFile = Opt.m_InMultiplierFile;

    m_OutWeightFile = Opt.m_OutWeightFile;

    m_OutPathSpaceFile = Opt.m_OutPathSpaceFile;

    m_OutMultiplierFile = Opt.m_OutMultiplierFile;



    m_CurveContainer = Opt.m_CurveContainer;



    super::copyFrom( Opt );

}





//

//   p a r s e P a r a m

//



tRetCode tOptimizer::parseParam( tParser& Parser, tParseInfoStub& Info )



{

    tRetCode nRet;

    tFileName* pFileName;



    switch( Parser.curToken() ) {

        case xTokMultiplier :

            if( m_InMultiplierFile.isValid() )

                return Parser.setError( ATTR_REDEFINITION );

            if( ( nRet = Parser.readToken() ) != OK ||

                ( nRet = m_InMultiplierFile.parseRead( Parser ) ) != OK ) {

                return nRet;

            }

            break;



        case xTokSave :

            if( ( nRet = Parser.readToken() ) != OK )

                return nRet;



            if( Parser.curToken() == xTokCurve ||

                Parser.curToken() == xTokId ) {

                if( ( nRet = Parser.readToken() ) != OK ||

                    ( nRet = m_CurveContainer.parse( Parser ) ) != OK ) {

                    return nRet;

                }

            }

            else {

                switch( Parser.curToken() ) {

                    case xTokWeight :

                        pFileName = &m_OutWeightFile;

                        break;



                    case xTokPathSpace :

                        pFileName = &m_OutPathSpaceFile;

                        break;



                    case xTokMultiplier :

                        pFileName = &m_OutMultiplierFile;

                        break;



                    default :

                        return Parser.setError( INVALID_KEYWORD );

                }



                if( pFileName->isValid() )

                    return Parser.setError( ATTR_REDEFINITION );



                if( ( nRet = Parser.readToken() ) != OK ||

                    ( nRet = pFileName->parseWrite( Parser ) ) != OK ) {

                    return nRet;

                }

            }

            break;



        case xTokCurve :

            if( ( nRet = Parser.readToken() ) != OK ||

                ( nRet = m_CurveContainer.parse( Parser ) ) != OK ) {

                return nRet;

            }

            break;

       

        default :

            return super::parseParam( Parser, Info );

    }



    return OK;

}





//

//   t O p t i m i z e r

//



tOptimizer::tOptimizer()



{

}





//

//   t O p t i m i z e r

//



tOptimizer::tOptimizer( const tOptimizer& Opt )



{  

    copyFrom( Opt );

}





//

//   ~ t O p t i m i z e r

//



tOptimizer::~tOptimizer()



{

}





//

//   f i n a l i z e

//



tRetCode tOptimizer::finalize()



{

    return super::finalize();

}





//

//   l o a d M u l t i p l i e r s

//



tRetCode tOptimizer::loadMultipliers( const tPortfolio& Portfolio,

    tHeap<double>& Multiplier ) const



{

    tRetCode nRet;



    if( ! m_InMultiplierFile.isValid() )

        return OK;

    

    if( ( nRet = Portfolio.loadMultipliers( m_InMultiplierFile,

                    Multiplier ) ) != OK ) {

        if( nRet == GO )

            return OK;

        return nRet;

    }

    return OK;

}





//

//   s a v e P a t h S p a c e

//



tRetCode tOptimizer::savePathSpace( const tPathSpace& PathSpace ) const



{

    return PathSpace.save( m_OutPathSpaceFile );

}





//

//   s a v e P a t h S p a c e

//



tRetCode tOptimizer::savePathSpace( const tPathSpace& PathSpace,

    const tHeap<double>& Weight ) const



{

    return PathSpace.save( m_OutPathSpaceFile, Weight );

}





//

//   s a v e W e i g h t s

//



tRetCode tOptimizer::saveWeights( const tHeap<double>& Weight ) const



{

    if( ! m_OutWeightFile.isValid() )

        return OK;



    tRetCode nRet;

    ofstream Out;

    

    Out << setprecision( DBL_DIG );



    if( ( nRet = m_OutWeightFile.openWrite( Out, "weights" ) ) != OK ||

        ( nRet = Weight.save( Out, 1 ) ) != OK ) {

        return nRet;

    }



    Out.close();

    return OK;

}





//

//   s a v e M u l t i p l i e r s

//



tRetCode tOptimizer::saveMultipliers( const tPortfolio& Portfolio,

    const tHeap<double>& Multiplier ) const



{

    if( ! m_OutMultiplierFile.isValid() )

        return OK;

    return Portfolio.saveMultipliers( m_OutMultiplierFile, Multiplier );

}





//

//   p a r s e

//



tRetCode tOptimizer::parse( tParser& Parser, tSystem& System, tObject*& pObj )



{

    tRetCode nRet;

    tOptimizer* pOpt;

    tToken nType;

    tParseInfo Info;



    Info.m_bParam1 = false;

    Info.m_bParam2 = false;



    if( ( nRet = parseType( Parser, nType, xTokEntropy ) ) != OK )

        return nRet;



    switch( nType ) {

        case xTokEntropy :

            pOpt = new tEntropyOpt;

            break;



        default :

            return Parser.setError( INVALID_KEYWORD );

    }



    pOpt->setSystem( System );



    if( ( nRet = pOpt->super::parse( Parser, &Info ) ) != OK ) {

        delete pOpt;

        return nRet;

    }

    pObj = pOpt;



    return OK;

}



MTG_END_NAMESPACE

