// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgPayment.h"

#include "MtgCompounder.h"



MTG_BEGIN_NAMESPACE





//

//   c r e a t e

//



void tPayment::create( tDate Start, tDate End, double gRedemption,

    double gCoupon, const tCompounder& Compounder, tHeap<tPayment>& Payment )



{

    int nPeriods = Compounder.numOfPeriodsPerYear();

    MTG_ASSERT( nPeriods > 0 );



    gCoupon /= nPeriods;



    tDate Date = Start;

    tDate PeriodStart, PeriodEnd;



    Compounder.getCompoundingPeriod( Date, PeriodStart, PeriodEnd );



        // collect all the coupons



    while( PeriodEnd <= End ) {

        Payment.append( tPayment( PeriodEnd, gCoupon ) );

        Compounder.getNextCompoundingPeriod( PeriodStart, PeriodEnd );

    }



        // add redemption value



    if( Payment.numOfElems() > 0 && Payment.last().m_Date == End )

        Payment.last().m_gAmount += gRedemption;

    else

        Payment.append( tPayment( End, gRedemption ) );

}



MTG_END_NAMESPACE



