// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_PAYMENT_)

#define _MTG_PAYMENT_



#include "MtgDate.h"

#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE



class tCompounder;





//

//   t P a y m e n t

//



struct tPayment {



    tDate m_Date;

    double m_gAmount;



    tPayment() {

        m_gAmount = 0;

    }



    tPayment( tDate Date, double gAmount ) {

        m_Date = Date;

        m_gAmount = gAmount;

    }



    tPayment( const tPayment& Payment ) {

        m_Date = Payment.m_Date;

        m_gAmount = Payment.m_gAmount;

    }



    static void create( tDate Start, tDate End, double gRedemption,

        double gCoupon, const tCompounder& Compounder,

        tHeap<tPayment>& Payment );

};



MTG_END_NAMESPACE



#endif

