// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgRepository.h"

#include "MtgSystem.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tRepository::init()



{

    m_pFirst = 0;

    m_pLast = 0;

    setSystem( new tSystem );

}





//

//   c l e a n u p

//



void tRepository::cleanup()



{

    while( m_pFirst != 0 )

        remove( m_pFirst );

}





//

//   c o p y F r o m

//



void tRepository::copyFrom( const tRepository& Rep )



{

    if( &Rep == this )

        return;



    cleanup();



    tWrapper* p = Rep.m_pFirst;



    while( p != 0 ) {

        tWrapper* q = new tWrapper;

        q->m_pObj = q->m_pObj->clone();

        insert( q );

        p = p->m_pNext;

    }



    super::copyFrom( Rep );

}





//

//   i n s e r t

//



void tRepository::insert( tWrapper* pWrapper )



{

    pWrapper->m_pObj->upRef();



    pWrapper->m_pNext = 0;

    pWrapper->m_pPrev = m_pLast;

    if( m_pLast != 0 )

        m_pLast->m_pNext = pWrapper;

    else

        m_pFirst = pWrapper;

    m_pLast = pWrapper;



    m_Lookup.insert( pWrapper->m_pObj->name(), pWrapper );

}





//

//   r e m o v e

//



void tRepository::remove( tWrapper* pWrapper )



{

    if( pWrapper->m_pPrev == 0 )

        m_pFirst = pWrapper->m_pNext;

    else

        pWrapper->m_pPrev->m_pNext = pWrapper->m_pNext;

    if( pWrapper->m_pNext == 0 )

        m_pLast = pWrapper->m_pPrev;

    else

        pWrapper->m_pNext->m_pPrev = pWrapper->m_pPrev;



    pWrapper->m_pObj->downRef();

    if( pWrapper->m_pObj->canDelete() )

        delete pWrapper->m_pObj;



    delete pWrapper;

}





//

//   t R e p o s i t o r y

//



tRepository::tRepository()



{

    init();

}





//

//   t R e p o s i t o r y

//



tRepository::tRepository( const tRepository& Rep )



{

    init();

    copyFrom( Rep );

}





//

//   ~ t R e p o s i t o r y

//



tRepository::~tRepository()



{

    cleanup();

}





//

//   o p e r a t o r =

//



tRepository& tRepository::operator=( const tRepository& Rep )



{

    if( &Rep != this )

        copyFrom( Rep );

    return *this;

}





//

//   i n s e r t

//



void tRepository::insert( tObject* pObj )



{

    MTG_ASSERT( pObj != 0 );

    MTG_ASSERT( ! pObj->isAnonymous() );



    tWrapper* p;

    

    if( m_Lookup.retrieve( pObj->name(), p ) == OK ) {

        p->m_pObj->downRef();

        if( p->m_pObj->canDelete() )

            delete p->m_pObj;

        pObj->upRef();

        p->m_pObj = pObj;

    }

    else {

        p = new tWrapper;

        p->m_pObj = pObj;

        insert( p );

    }



    pObj->setSystem( system() );

}





//

//   f i n d

//



tObject* tRepository::find( const char* sName ) const



{

    MTG_ASSERT( sName != 0 );



    tWrapper* p;

    

    if( m_Lookup.retrieve( sName, p ) == OK )

        return p->m_pObj;

    return 0;

}



MTG_END_NAMESPACE