// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_REPOSITORY_)

#define _MTG_REPOSITORY_



#include "MtgObject.h"

#include "MtgLookup.h"



MTG_BEGIN_NAMESPACE



class tSystem;





//

//   t R e p o s i t o r y

//



class tRepository : public tWithSystem {



    typedef tWithSystem super;



        // A repository always has a system object  

        // assigned to it, which it shares with

        // the objects it maintains through the

        // reference mechanism.



    struct tWrapper {

        tWrapper* m_pPrev;

        tWrapper* m_pNext;

        tObject* m_pObj;

    };



    tLookup<tWrapper*> m_Lookup;



    tWrapper* m_pFirst;

    tWrapper* m_pLast;



    void init();

    void cleanup();



    void copyFrom( const tRepository& Rep );



    void insert( tWrapper* pWrapper );

    void remove( tWrapper* pWrapper );



public:



    tRepository();

    tRepository( const tRepository& Rep );



    ~tRepository();



    tRepository& operator=( const tRepository& Rep );



    void insert( tObject* pObj );

    tObject* find( const char* sName ) const;

};



MTG_END_NAMESPACE



#endif

