// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgSamplePath.h"

#include "MtgRandom.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tSamplePath::copyFrom( const tSamplePath& Path )



{

    m_nNumOfFactors = Path.m_nNumOfFactors;

    m_nNumOfSamples = Path.m_nNumOfSamples;

    m_nSeed1 = Path.m_nSeed1;

    m_nSeed2 = Path.m_nSeed2;

    m_gAlpha = Path.m_gAlpha;

    m_gBeta = Path.m_gBeta;

    m_Sample = Path.m_Sample;

}





//

//   t S a m p l e P a t h

//



tSamplePath::tSamplePath()



{

    m_nNumOfFactors = 0;

    m_nNumOfSamples = 0;

}





//

//   t S a m p l e P a t h

//



tSamplePath::tSamplePath( int nNumOfFactors, int nNumOfSamples )



{

    MTG_ASSERT( nNumOfFactors >= 0 && nNumOfSamples >= 0 );



    m_nNumOfFactors = nNumOfFactors;

    m_nNumOfSamples = nNumOfSamples;

}





//

//   t S a m p l e P a t h

//



tSamplePath::tSamplePath( const tSamplePath& Path )



{

    copyFrom( Path );

}





//

//   o p e r a t o r =

//



tSamplePath& tSamplePath::operator=( const tSamplePath& Path )



{

    if( &Path != this )

        copyFrom( Path );

    return *this;

}





//

//   s e t N u m O f F a c t o r s

//



void tSamplePath::setNumOfFactors( int nNumOfFactors )



{

    MTG_ASSERT( nNumOfFactors > 0 );

    m_nNumOfFactors = nNumOfFactors;

}





//

//   s e t N u m O f S a m p l e s

//



void tSamplePath::setNumOfSamples( int nNumOfSamples )



{

    MTG_ASSERT( nNumOfSamples > 0 );

    m_nNumOfSamples = nNumOfSamples;

}





//

//   b u i l d

//



void tSamplePath::build( long nSeed1, long nSeed2 )



{

    tRandom Random( nSeed1, nSeed2 );

    build( Random );

}





//

//   b u i l d

//



void tSamplePath::build( tRandom& Random )



{

    MTG_ASSERT( m_nNumOfFactors > 0 && m_nNumOfSamples > 0 );



        // allocate space



    if( m_Sample.numOfCols() != m_nNumOfFactors )

        m_Sample.reset( m_nNumOfFactors );

    if( m_Sample.numOfRows() != m_nNumOfSamples )

        m_Sample.numOfRows( m_nNumOfSamples );



        // remember status of random number generator



    Random.getSeed( m_nSeed1, m_nSeed2 );

    Random.normal( m_Sample );



    m_gAlpha = 1;

    m_gBeta = 0;

}





//

//   t r a n s f o r m

//



void tSamplePath::transform( double gAlpha, double gBeta )



{

    int nRows = m_Sample.numOfRows();

    int nCols = m_Sample.numOfCols();



    if( gBeta == 0 ) {

        for( int r = 0; r < nRows; ++r ) {

            for( int c = 0; c < nCols; ++c )

                m_Sample[r][c] = gAlpha * m_Sample[r][c];

        }

    }

    else {

        for( int r = 0; r < nRows; ++r ) {

            for( int c = 0; c < nCols; ++c )

                m_Sample[r][c] = gAlpha * m_Sample[r][c] + gBeta;

        }

    }



    m_gAlpha *= gAlpha;

    m_gBeta *= gAlpha;

    m_gBeta += gBeta;

}





//

//   c o l l a p s e

//



void tSamplePath::collapse()



{

    m_Sample.clear();

}





//

//   r e b u i l d

//



void tSamplePath::rebuild()



{

    MTG_ASSERT( m_nNumOfFactors > 0 && m_nNumOfSamples > 0 );



    double gAlpha = m_gAlpha;

    double gBeta = m_gBeta;



    tRandom Random( m_nSeed1, m_nSeed2 );



    build( Random );

    transform( gAlpha, gBeta );

}



MTG_END_NAMESPACE