// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SCANNER_)

#define _MTG_SCANNER_



#include "MtgHeap.h"

#include "MtgSource.h"



MTG_BEGIN_NAMESPACE





//

//   t S c a n n e r

//



class tScanner {



    char m_sErrorMsg[1024];



    tSource* m_pSrc;            // current source, referenced

    tHeap<tSource*> m_Stack;    // the include stack; all

                                // sources in here are owned



    void clearError();



    tRetCode checkInclude();



        // Scanners must not be copied, as access to the source

        // is not synchronized. They are throw-away objects.



    tScanner( const tScanner& ) {

        throw tException( INTERNAL_ERROR );

    }



protected:



    void cleanup();



public:



    tScanner();

    ~tScanner();



        // The source is not owned; simply a reference

        // is recorded.



    tRetCode setSource( tSource& Src ) {

        return setSource( &Src );

    }

    tRetCode setSource( tSource* pSrc = 0 );



    tRetCode setError( const char *sFmt, ... );

    tRetCode setError( tRetCode nRet );



    bool isSafe() const {

        return m_pSrc != 0 && m_pSrc->isSafe();

    }



    bool beginOfNumber();



    tRetCode readToken();



    tRetCode swallowToken( tToken nToken, char* sPrintName );

    tRetCode swallowComma( bool& bGo );



    tRetCode scanInteger( int& nValue, int nLowerBound = 1 );

    tRetCode scanInteger( long& nValue, long nLowerBound = 1 );

    tRetCode scanDouble( double& gValue );

    tRetCode scanPosDouble( double& gValue );

    tRetCode scanNonNegDouble( double& gValue );

    tRetCode scanRange( double& gMin, double& gMax );

    tRetCode scanRange( double& gMin, double& gMid, double& gMax );

    tRetCode scanPosRange( double& gMin, double& gMax );

    tRetCode scanPosRange( double& gMin, double& gMid, double& gMax );

    tRetCode scanNonNegRange( double& gMin, double& gMax );

    tRetCode scanNonNegRange( double& gMin, double& gMid, double& gMax );

    tRetCode scanPercentage( double& gValue );

    tRetCode scanPosPercentage( double& gValue );

    tRetCode scanNonNegPercentage( double& gValue );

    tRetCode scanPercentageRange( double& gMin, double& gMax );

    tRetCode scanPercentageRange( double& gMin, double& gMid, double& gMax );

    tRetCode scanPosPercentageRange( double& gMin, double& gMax );

    tRetCode scanPosPercentageRange( double& gMin, double& gMid,

        double& gMax );

    tRetCode scanNonNegPercentageRange( double& gMin, double& gMax );

    tRetCode scanNonNegPercentageRange( double& gMin, double& gMid,

        double& gMax );



    tRetCode scanString( char*& sString );

    tRetCode scanDate( tDate& Value );



    tToken curToken() const {

        MTG_ASSERT( m_pSrc != 0 );

        return m_pSrc->m_nCurToken;

    }



    double curValue() const {

        MTG_ASSERT( m_pSrc != 0 );

        return m_pSrc->m_gCurValue;

    }



    const char* curText() const {

        MTG_ASSERT( m_pSrc != 0 );

        return m_pSrc->m_sCurText;

    }



    tDate curDate() const {

        MTG_ASSERT( m_pSrc != 0 );

        return m_pSrc->m_CurDate;

    }



    bool tryDate( tDate& Date ) const {

        MTG_ASSERT( m_pSrc != 0 );

        return m_pSrc->tryDate( Date );

    }



    const char* getErrorMsg() const {

        return m_sErrorMsg;

    }

};



MTG_END_NAMESPACE



#endif

