// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SCENARIO_)

#define _MTG_SCENARIO_



#include "MtgObject.h"

#include "MtgSlotLayer.h"



MTG_BEGIN_NAMESPACE



class tEvGenerator;

class tFDEngine;





//

//   t S c e n a r i o

//



class tScenario : public tObject {



    typedef tObject super;



    struct tParseInfo : super::tParseInfoStub {

        bool m_bPosition;

        bool m_bParam1;

        bool m_bParam2;

        bool m_bParam3;

    };



public:



    enum tPosition {

        xBuyer,

        xSeller

    };



private:



    tPosition m_nPosition;

    bool m_bExhaustive;     // for debug purposes



    void init();



protected:



    tPosition position() const {

        return m_nPosition;

    }



    bool isExhaustive() const {

        return m_bExhaustive;

    }



    void reset();

    void copyFrom( const tScenario& Scenario );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );



public:



    tScenario();

    tScenario( const tScenario& Scenario );



    ~tScenario();



    tRetCode finalize();



    void setExhaustive( bool bExhaustive );



    virtual tEvGenerator* getEvGenerator( int nMaturity ) const {

        return 0;

    }



    virtual bool underControl( double gMultiplier ) {

        return false;

    }



    virtual void refineExPolicy( tFDEngine& Engine, int nBaseTag,

        int nIndex, double gDontExValue, double gExValue, 

        double gMultiplier, tExPolicy& nExPolicy );



    virtual void refineExPolicy( tFDEngine& Engine, int nBaseTag, 

        int nIndex, double gDontExValue, double gExValue,

        double gMultiplier, tExPolicy& nExPolicy, tExPolicy& nExPolicy0 );



    virtual double selectVol( int nTag, double gGamma, double gPrior,

        double gMin, double gMax ) = 0;



        // endureOver() imposes the scenario order if the opponent

        // controls the alternatives. chooseOver() returns the

        // preference if we control the alternatives.



    virtual bool endureOver( int nTag, double gNewTotal,

        double gOldTotal ) = 0;



    virtual bool chooseOver( int nTag, double gNewTotal,

        double gOldTotal ) = 0;



    static tRetCode parse( tParser& Parser, tSystem& System, tObject*& pObj );

};



MTG_END_NAMESPACE



#endif

