// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SERVICE_)

#define _MTG_SERVICE_



#if defined(_WIN32)

    #define _WIN32_WINNT 0x0400

    #include <windows.h>

#endif



MTG_BEGIN_NAMESPACE





//

//   t S e r v i c e

//



class tService {



    enum tActivity {

        xUnknown,

        xSkip,

        xRun,

        xInstall,

        xRemove,

        xStart,

        xStop,

        xQuery,

        xChild

    };



    char* m_sName;

    tActivity m_nActivity;

    bool m_bIsInteractive;



    int m_argc;

    const char** m_argv;

    int m_nErrCode;



    int (*m_main)( int argc, const char* argv[] );



    bool appendToPath( char* sPath, size_t nLength,

        int argc, const char* argv[] );



    bool makePath( char* sPath, size_t nLength,

        int argc, const char* argv[], const char* sArg0 = 0 );



#if defined(_WIN32)



    SERVICE_STATUS m_Status;

    SERVICE_STATUS_HANDLE m_hStatus;



    bool m_bHasChild;

    bool m_bKillChild;

    PROCESS_INFORMATION m_Child;



    HANDLE m_hStopReq;

    HANDLE m_hStopAck;



    static tService* m_pThis;   // used to pass service object

                                // to serviceStartHandler



    tRetCode openService( SC_HANDLE& hManager, SC_HANDLE& hService );

    void closeService( SC_HANDLE hManager, SC_HANDLE hService );



    static void _stdcall serviceStartHandler( DWORD argc, LPTSTR *argv ); 

    static void _stdcall serviceCtrlHandler( DWORD nOpcode ); 



    static void serviceRunThread( void* pThis );

    static void serviceStopThread( void* pThis );

    static void serviceChildThread( void* pThis );



protected: 



    virtual void serviceStart( DWORD argc, LPTSTR *argv );

    virtual void serviceCtrl( DWORD nOpcode );



    virtual bool serviceInit();

    virtual void serviceRun();

    virtual void serviceStop();

    virtual void serviceChild();



#endif



public:



    tService();

    ~tService();



    void setName( const char* sName );



    tRetCode install( int argc, const char* argv[] );

    tRetCode install( const char* sName, int argc, const char* argv[] );



    tRetCode remove();

    tRetCode start( int argc, const char* argv[] );

    tRetCode stop();

    tRetCode query();



    tRetCode run( int (*main)( int argc, const char* argv[] ),

        int argc, const char* argv[], int& nErrCode );



        // useArgs() sets m_nActivity; afterwards, the

        // activity is initiated with a call to perform().



    tRetCode useArgs( int& argc, const char* argv[] );

    tRetCode perform( int (*main)( int argc, const char* argv[] ),

        int argc, const char* argv[], int& nErrCode );



    tRetCode perform( int (*main)( int argc, const char* argv[] ),

        int argc, const char* argv[], int& nErrCode, bool& bIsInteractive );



        // After perform() has returned GO, the following function

        // determines whether we're interactive or in the background

        // (note that the second version of perform() returns exactly

        // this value):



    bool isInteractive() const {

        return m_bIsInteractive;

    }

};



MTG_END_NAMESPACE



#endif

