// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgShockEngine.h"

#include "MtgClaim.h"

#include "MtgShockScenario.h"



MTG_BEGIN_NAMESPACE





//

//   t S h o c k S p e c i f i c

//



tShockEngine::tShockSpecific::tShockSpecific( tShockEngine& Engine )

    : tOFSpecific( Engine )



{

}





//

//   i n i t

//



void tShockEngine::init()



{

}





//

//   n o n A u x P r e p r o c e s s

//



void tShockEngine::nonAuxPreprocess()



{

    MTG_ASSERT( m_nCurAction == xReset );



    double gTotal = 0;

    double* Th = lastRow();

    double* Co = m_pCurCoLayer->lastRow( pos() );



    for( tSlotLayer::tIter I( *m_pLayer ); I; ++I ) {

        if( I.claim().maturity() > day() ) {

            Th[I.xlat()] = Co[m_pCurCoLayer->xlatIndex( I.index() )];

            gTotal += multiplier()[I.index()] * Th[I.xlat()];

        }

    }



    lastTotal() = gTotal;

}





//

//   n o n A u x P o s t p r o c e s s

//



void tShockEngine::nonAuxPostprocess()



{

    MTG_ASSERT( m_nCurAction == xCompare );



    if( scenario().endureOver( m_nCurTag,

            m_pCurCoLayer->curTotal( pos() ), curTotal() ) ) {

        m_pLayer->curCopyFrom( *m_pCurCoLayer, pos() );

        if( hasProfile() )

            profile().putAlternative( 2, m_pCurCoLayer );

    }

}





//

//   b e f o r e T a s k 1

//



void tShockEngine::beforeTask1( tSlotLayer& Layer, tSpecific*& pSpecific )



{

    if( pSpecific == 0 ) {

        m_pSpecific = new tShockSpecific( *this );

        pSpecific = m_pSpecific;

    }

    else {

        m_pSpecific = static_cast<tShockSpecific*>( pSpecific );

    }



    super::beforeTask1( Layer, pSpecific );



    m_nCurTag = Layer.tag();

    m_nCurAction = xCarry;

    m_pCurCoLayer = 0;



    tTagDesc& T = m_TagDesc[m_nCurTag];



    switch( T.m_nAction ) { 

        case xCarry: 

                // ignore

            break;



        case xReset :

            if( atDusk() ) {

                int nStartDay = day() + 1 - m_nDuration;



                if( nStartDay >= 0 && nStartDay % m_nPeriodicity == 0 ) {

                    int nOffset = ( nStartDay / m_nPeriodicity ) % m_nDepth;



                    if( T.m_nOffset == nOffset ) {

                        getNonAuxLayer( *Layer.signature(), T.m_nOtherTag,

                            m_pCurCoLayer );

                        m_nCurAction = xReset;

                        if( *Layer.signature() == *m_pCurCoLayer->signature() ) {

                                // don't set the proprocess flag; we can

                                // do it faster here

                            Layer.lastCopyFrom( *m_pCurCoLayer );

                        }

                        else {

                                // do it row by row

                            setPreprocess();

                        }

                    }

                }

            }

            break;



        case xCompare :

            if( ! isFinal() && atDawn() && day() % m_nPeriodicity == 0 ) {

                int nOffset = ( day() / m_nPeriodicity ) % m_nDepth;



                getNonAuxLayer( *Layer.signature(),

                    2 * nOffset + T.m_nOtherTag, m_pCurCoLayer );

                m_nCurAction = xCompare;

                setPostprocess();

            }

            break;



        default :

            throw tException( INTERNAL_ERROR );

    }

}





//

//   a f t e r T a s k 1

//



void tShockEngine::afterTask1()



{

    super::afterTask1();



    m_pSpecific->m_nCurTag = m_nCurTag;

    m_pSpecific->m_nCurAction = m_nCurAction;

    m_pSpecific->m_pCurCoLayer = m_pCurCoLayer;

}





//

//   b e f o r e T a s k 2

//



void tShockEngine::beforeTask2( tSlotLayer& Layer, tSpecific*& pSpecific )



{

    super::beforeTask2( Layer, pSpecific );



    m_pSpecific = static_cast<tShockSpecific*>( pSpecific );



    m_nCurTag = m_pSpecific->m_nCurTag;

    m_nCurAction = m_pSpecific->m_nCurAction;

    m_pCurCoLayer = m_pSpecific->m_pCurCoLayer;

}





//

//   b e f o r e R u n

//



tRetCode tShockEngine::beforeRun()



{

    tRetCode nRet;

    tSlotLayer* pLayer;



    tShockScenario& Scenario = 

        dynamic_cast<tShockScenario&>( scenario() );



    m_nDuration = Scenario.duration();

    m_nPeriodicity = Scenario.periodicity();

    m_nDepth = ( m_nDuration + m_nPeriodicity - 1 ) / m_nPeriodicity;



    m_TagDesc.numOfElems( 1 + ( 1 + m_nDepth ) * 2 * Scenario.repetitions() );



    int k = 0;

    for( int i = 0; i < Scenario.repetitions(); ++i ) {

        for( int j = 0; j < 2; ++j, ++k ) {

            m_TagDesc[k].m_nAction = xCompare;

            m_TagDesc[k].m_nOtherTag = k + 2;

            m_TagDesc[k].m_bPricedAtPrior = true;



            MTG_TRACE( "ShockEngine: compare-tag %d (with tag %d..%d)\n",

                k, m_TagDesc[k].m_nOtherTag, 

                m_TagDesc[k].m_nOtherTag + 2 * ( m_nDepth - 1 ) );

        }



        int nOtherTag = k + 2 * m_nDepth;

        for( MTG_FOR_INIT( int ) j = 0; j < m_nDepth; ++j ) {

            m_TagDesc[k].m_nAction = xReset;

            m_TagDesc[k].m_nOtherTag = nOtherTag;

            m_TagDesc[k].m_nPeriodicity = m_nPeriodicity * m_nDepth;

            m_TagDesc[k].m_nOffset = j;

            m_TagDesc[k].m_bPricedAtPrior = false;



            MTG_TRACE( "ShockEngine: reset-tag %d, offset %d (with tag %d)\n",

                k, m_TagDesc[k].m_nOffset, m_TagDesc[k].m_nOtherTag );



            ++k;

            

            m_TagDesc[k].m_nAction = xReset;

            if( i < Scenario.repetitions() - 1 )

                m_TagDesc[k].m_nOtherTag = nOtherTag + 1;

            else

                m_TagDesc[k].m_nOtherTag = nOtherTag;

            m_TagDesc[k].m_nPeriodicity = m_nPeriodicity * m_nDepth;

            m_TagDesc[k].m_nOffset = j;

            m_TagDesc[k].m_bPricedAtPrior = false;



            MTG_TRACE( "ShockEngine: reset-tag %d, offset %d (with tag %d)\n",

                k, m_TagDesc[k].m_nOffset, m_TagDesc[k].m_nOtherTag );

                

            ++k;

        }

    }



    MTG_ASSERT( k == m_TagDesc.numOfElems() - 1 );



    m_TagDesc.last().m_nAction = xCarry;

    m_TagDesc.last().m_bPricedAtPrior = true;



    MTG_TRACE( "ShockEngine: prior-tag %d\n", m_TagDesc.numOfElems() - 1 );



    if( ( nRet = super::beforeRun() ) != OK )

        return nRet;



    for( MTG_FOR_INIT( int ) k = 2; k < m_TagDesc.numOfElems(); k += 2 ) { 

        if( ( nRet = createNonAuxLayer( k, pLayer ) ) != OK )

            return nRet;

    }



    return OK;

}





//

//   a f t e r R u n

//



tRetCode tShockEngine::afterRun()



{

    return super::afterRun();

}





//

//   m o d i f y M o d e

//



void tShockEngine::modifyMode( int nTag, tMode& nMode ) const



{

    if( m_TagDesc[nTag].m_bPricedAtPrior )

        nMode = xPrior;

}





//

//   t S h o c k E n g i n e

//



tShockEngine::tShockEngine()



{

    init();

}





//

//   ~ t S h o c k E n g i n e

//



tShockEngine::~tShockEngine()



{

}



MTG_END_NAMESPACE