// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SHOCK_ENGINE_)

#define _MTG_SHOCK_ENGINE_



#include "MtgGeoEngine.h"



MTG_BEGIN_NAMESPACE





//

//   t S h o c k E n g i n e

//



class tShockEngine : public tGeoEngine {



    typedef tGeoEngine super;



    enum tAction  {

        xCarry,     // don't do anything

        xReset,     // reset with other layer

        xCompare    // compare with other layer

    };



    struct tTagDesc {

        tAction m_nAction;

        int m_nOtherTag;

        int m_nPeriodicity;

        int m_nOffset;

        bool m_bPricedAtPrior;

    };



    struct tShockSpecific : public super::tOFSpecific {

        int m_nCurTag;

        tAction m_nCurAction;

        tSlotLayer* m_pCurCoLayer;



        tShockSpecific( tShockEngine& Engine );

    };



    int m_nDuration;

    int m_nPeriodicity;

    int m_nDepth;



    tHeap<tTagDesc> m_TagDesc;



    tShockSpecific* m_pSpecific;



    int m_nCurTag;

    tAction m_nCurAction;

    tSlotLayer* m_pCurCoLayer;



    void init();



    void nonAuxPreprocess();

    void nonAuxPostprocess();



    void beforeTask1( tSlotLayer& Layer, tSpecific*& pSpecific );

    void afterTask1();



    void beforeTask2( tSlotLayer& Layer, tSpecific*& pSpecific );



    tRetCode beforeRun();

    tRetCode afterRun();



    void modifyMode( int nTag, tMode& nMode ) const;



public:



    tShockEngine();

    ~tShockEngine();

};



MTG_END_NAMESPACE



#endif

