// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SHOCK_SCENARIO_)

#define _MTG_SHOCK_SCENARIO_



#include "MtgEvGenerator.h"

#include "MtgWorstCase.h"



MTG_BEGIN_NAMESPACE





//

//   t S o c k S c e n a r i o

//



class tShockScenario : public tWorstCase {



    typedef tWorstCase super;



    int m_nDuration;        // duration of shock in days

    int m_nPeriodicity;     // periodicity, starting today, in days

    int m_nRepetitions;     // number of non-overlapping shocks



    void init();



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );



public:



    tShockScenario();

    tShockScenario( const tShockScenario& Shock );



    ~tShockScenario();



    void reset();



    tShockScenario& operator=( const tShockScenario& Shock );



    void copyFrom( const tShockScenario& Shock );



    tObject* clone() const;



    int duration() const    { return m_nDuration; }

    int periodicity() const { return m_nPeriodicity; }

    int repetitions() const { return m_nRepetitions; }



    tEvGenerator* getEvGenerator( int nMaturity ) const;



    tRetCode finalize();

};



MTG_END_NAMESPACE



#endif

