// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SHORT_RATE_ENGINE_)

#define _MTG_SHORT_RATE_ENGINE_



#include "MtgMCEngine.h"

#include "MtgShortRateTermStruct.h"



MTG_BEGIN_NAMESPACE



class tSamplePath;





//

//   t S h o r t R a t e E n g i n e

//



class tShortRateEngine : public tMCEngine {



    typedef tMCEngine super;



    tShortRateTermStruct m_TermStruct;



    void init();



    tRetCode beforeRun();

    tRetCode afterRun();



    tRetCode preparePath();



public:



    tShortRateEngine();

    ~tShortRateEngine();



        // The day and date forms:



    const tDateBase& dateBase() const;

    const tDateRange& dateRange() const;



    double forward( double gFromDay, double gToDay ) const;

    double forward( tDate Start, tDate End ) const;



    double presentValue( double gFromDay, double gToDay ) const;        

    double futureValue( double gFromDay, double gToDay ) const;        



    double presentValue( tDate Start, tDate End ) const;

    double futureValue( tDate Start, tDate End ) const;



        // The SI form:



    double forwardSI( double gFromSub, double gToSub ) const;



    double presentValueSI( double gFromSub, double gToSub ) const;        

    double futureValueSI( double gFromSub, double gToSub ) const;        

};



MTG_END_NAMESPACE



#endif

