// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SIG_ASSOC_)

#define _MTG_SIG_ASSOC_



#include "MtgHeap.h"

#include "MtgSignature.h"



MTG_BEGIN_NAMESPACE





//

//   t S i g A s s o c

//



template <class T>    

class tSigAssoc {



    struct tEntry {

        tSignature *m_pSig;

        T m_Data;

    };



        // m_aEntry is the heap that stores all the data. The data

        // is found by using each byte in the signature in turn

        // to access elements in index pages, stored in m_aIndex.

        // Each index page is 256 integer values long. Each entry

        // in an index page references another index page or

        // a data entry.



    struct tGroup {

        tHeap<tEntry> m_Entry;

        tHeap<int*> m_Index;

        int m_Index0[256];

    };



        // There is one group for each tag.



    tHeap<tGroup*> m_Group;



        // The signature heap accepts only uniformly sized signatures.

        // The first signature that enters the heap determines the size

        // that all additional signatures must have.



    int m_nNumOfFlags;

    int m_nNumOfSigs;



        // Some helper functions.



    void init();



    tGroup& getGroup( int nTag );



public:



    tSigAssoc();

    tSigAssoc( const tSigAssoc& Assoc );



    ~tSigAssoc();



    void reset();



    tSigAssoc& operator=( const tSigAssoc& Assoc );



    void copyFrom( const tSigAssoc& Assoc );



    int numOfFlags() const {

        return m_nNumOfFlags;

    }



    int numOfSigs() const {

        return m_nNumOfSigs;

    }



    tRetCode insert( const tSignature& Sig, int nTag, T& Data );

    tRetCode retrieve( const tSignature& Sig, int nTag, T& Data );



    tRetCode insert( const tSignature& Sig, T& Data ) {

        return insert( Sig, Sig.tag(), Data );

    }



    tRetCode retrieve( const tSignature& Sig, T& Data ) {

        return retrieve( Sig, Sig.tag(), Data );

    }

};



MTG_END_NAMESPACE



#if ! defined(_MTG_SIG_ASSOC_BODY_)

    #define _MTG_SIG_ASSOC_HEADER_

    #if defined(_WIN32)

        #include "MtgSigAssoc.cpp"

    #else   

        #include "MtgSigAssoc.C"

    #endif

    #undef _MTG_SIG_ASSOC_HEADER_

#endif



#endif

