// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgSigBag.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tSigBag::init()



{

    m_pRefSignature = 0;

    reset();

}





//

//   t S i g B a g

//



tSigBag::tSigBag()



{

    init();

}





//

//   t S i g B a g

//



tSigBag::tSigBag( const tSigBag& Bag )



{

    init();

    copyFrom( Bag );

}





//

//   ~ t S i g B a g

//



tSigBag::~tSigBag()



{

}





//

//   o p e r a t o r =

//



tSigBag& tSigBag::operator=( const tSigBag& Bag )



{

    if( &Bag != this )

        copyFrom( Bag );

    return *this;

}





//

//   o p e r a t o r = =

//



bool tSigBag::operator==( const tSigBag& Bag ) const



{

    MTG_ASSERT( (*m_pRefSignature) == (*Bag.m_pRefSignature) );



    return m_ForceExIndex == Bag.m_ForceExIndex &&

           m_MayExIndex[0] == Bag.m_MayExIndex[0] &&

           m_MayExIndex[1] == Bag.m_MayExIndex[1];

}





//

//   c o p y F r o m

//



void tSigBag::copyFrom( const tSigBag& Bag )



{

    if( &Bag == this )

        return;



    reset();



    m_pRefSignature = Bag.m_pRefSignature;

    m_ForceExIndex = Bag.m_ForceExIndex;

    m_MayExIndex[0] = Bag.m_MayExIndex[0];

    m_MayExIndex[1] = Bag.m_MayExIndex[1];

    m_NumOfMayExIndex[0] = Bag.m_NumOfMayExIndex[0];

    m_NumOfMayExIndex[1] = Bag.m_NumOfMayExIndex[1];

    m_bHasAlternatives = Bag.m_bHasAlternatives;

    m_nAlternative0 = Bag.m_nAlternative0;

    m_nAlternative1 = Bag.m_nAlternative1;

    m_nAltNumOfExIndexes = Bag.m_nAltNumOfExIndexes;

    m_AltMayExIndex[0] = Bag.m_AltMayExIndex[0];

    m_AltMayExIndex[1] = Bag.m_AltMayExIndex[1];

    m_AltSignature = Bag.m_AltSignature;

}





//

//   s e t R e f S i g n a t u r e

//



void tSigBag::setRefSignature( const tSignature* pSig )



{

    m_pRefSignature = pSig;

    reset();

}





//

//   c o n s i d e r A l t e r n a t i v e

//



bool tSigBag::considerAlternative( int nAlternative0, int nAlternative1 )



{

    MTG_ASSERT( m_bHasAlternatives );



    m_nAlternative0 = nAlternative0;

    m_nAlternative1 = nAlternative1;



    m_nAltNumOfExIndexes = m_ForceExIndex.numOfElems();

    m_AltSignature = *m_pRefSignature;



    for( int i = 0; i < m_ForceExIndex.numOfElems(); ++i )

        m_AltSignature.off( m_ForceExIndex[i] );



    int k = 0;



    if( m_nAlternative0 >= 0 ) {

        m_AltSignature.off( m_MayExIndex[0][m_nAlternative0] );

        m_AltMayExIndex[k++] = m_MayExIndex[0][m_nAlternative0];

        ++m_nAltNumOfExIndexes;

    }

    if( m_nAlternative1 >= 0 ) {

        m_AltSignature.off( m_MayExIndex[1][m_nAlternative1] );

        m_AltMayExIndex[k] = m_MayExIndex[1][m_nAlternative1];

        ++m_nAltNumOfExIndexes;

    }



    return m_nAltNumOfExIndexes == 0;

}





//

//   c o n s i d e r A l t e r n a t i v e

//



void tSigBag::considerAlternative()



{

    MTG_ASSERT( m_bHasAlternatives );



        // selectAlternative( i, j ) plus considerAlternative()

        // are equivalent to considerAlternative( i, j ).



    m_AltSignature = *m_pRefSignature;



    for( int i = 0; i < m_ForceExIndex.numOfElems(); ++i )

        m_AltSignature.off( m_ForceExIndex[i] );



    if( m_nAlternative0 >= 0 )

        m_AltSignature.off( m_MayExIndex[0][m_nAlternative0] );

    if( m_nAlternative1 >= 0 )

        m_AltSignature.off( m_MayExIndex[1][m_nAlternative1] );

}





//

//   s e l e c t A l t e r n a t i v e

//



bool tSigBag::selectAlternative( int nAlternative0, int nAlternative1 )



{

    MTG_ASSERT( m_bHasAlternatives );



    m_nAlternative0 = nAlternative0;

    m_nAlternative1 = nAlternative1;



    m_nAltNumOfExIndexes = m_ForceExIndex.numOfElems();



    int k = 0;



    if( m_nAlternative0 >= 0 ) {

        m_AltMayExIndex[k++] = m_MayExIndex[0][m_nAlternative0];

        ++m_nAltNumOfExIndexes;

    }

    if( m_nAlternative1 >= 0 ) {

        m_AltMayExIndex[k] = m_MayExIndex[1][m_nAlternative1];

        ++m_nAltNumOfExIndexes;

    }



    return m_nAltNumOfExIndexes == 0;

}





//

//   g e t F o r c e E x N e g

//



void tSigBag::getForceExNeg( tSignature& Sig ) const



{

        // Generate the signature of the layer to which

        // the current layer is reduced if all the options

        // in m_ForceExIndex are exercised.



    Sig = *m_pRefSignature;

    for( int i = 0; i < m_ForceExIndex.numOfElems(); ++i )

        Sig.off( m_ForceExIndex[i] );

}





//

//   j u m p F o r c e E x X o r

//



bool tSigBag::jumpForceExXor( const tSigBag& Adj, tSignature& Sig ) const



{

    if( m_ForceExIndex == Adj.m_ForceExIndex )

        return false;



    Sig.reset( m_pRefSignature->numOfFlags() );



        // exclusive or:



    for( int i = 0; i < m_ForceExIndex.numOfElems(); ++i )

        Sig.on( m_ForceExIndex[i] );

    for( MTG_FOR_INIT( int ) i = 0; i < Adj.m_ForceExIndex.numOfElems(); ++i )

        Sig.toggle( Adj.m_ForceExIndex[i] );



    return true;

}





//

//   j u m p F o r c e E x A n d

//



bool tSigBag::jumpForceExAnd( const tSigBag& Adj, tSignature& Sig ) const



{

    Sig = *m_pRefSignature;



        // logical and:



    for( int i = 0; i < m_ForceExIndex.numOfElems(); ++i )

        Sig.off( m_ForceExIndex[i] );

    for( MTG_FOR_INIT( int ) i = 0; i < Adj.m_ForceExIndex.numOfElems(); ++i )

        Sig.toggle( Adj.m_ForceExIndex[i] );



    return ! Sig.isEmpty();

}





//

//   r e d u c e M a y E x

//



void tSigBag::reduceMayEx( tSignature& Sig ) const



{

    tSignature S( m_pRefSignature->numOfFlags() );



        // Turn off all flags in MayExSig which are not

        // registered in either one of the m_MayExIndex arrays.



    for( int j = 0; j < 2; ++j ) {

        for( int i = 0; i < m_MayExIndex[j].numOfElems(); ++i ) {

            S.on( m_MayExIndex[j][i] );                        

        }

    }



    Sig &= S;

}





//

//   e x t e n d M a y E x

//



void tSigBag::extendMayEx( const tSignature& Sig,

    const tHeap<bool>& UnderControl )



{

        // Move all the options whose flags is turned on

        // in Sig to the category "may exercise."



    for( int i = 0; i < Sig.numOfFlags(); ++i ) {

        if( Sig[i] ) {

            int b = UnderControl[i] ? 0 : 1;

            int j;



            for( j = 0; j < m_MayExIndex[b].numOfElems(); ++j ) {

                if( m_MayExIndex[b][j] == i )

                    break;

            }

            if( j == m_MayExIndex[b].numOfElems() )

                mayExercise( b, i );

        }

    }



    int k = 0;

    for( MTG_FOR_INIT( int ) i = 0; i < m_ForceExIndex.numOfElems(); ++i ) {

        if( ! Sig[m_ForceExIndex[i]] )

            m_ForceExIndex[k++] = m_ForceExIndex[i];

    }

    m_ForceExIndex.numOfElems( k );

}





//

//   e x t e n d F o r c e E x N e g

//



void tSigBag::extendForceExNeg( const tSignature* pSig,

    const tHeap<bool>& UnderControl )



{

    if( m_ForceExIndex.numOfElems() == 0 ) {

        if( pSig == 0 ) {

            for( int i = 0; i < m_pRefSignature->numOfFlags(); ++i ) {

                if( (*m_pRefSignature)[i] )

                    forceExercise( UnderControl[i], i );

            }

        }

        else {

            for( int i = 0; i < m_pRefSignature->numOfFlags(); ++i ) {

                if( ! (*pSig)[i] && (*m_pRefSignature)[i] )

                    forceExercise( UnderControl[i], i );

            }

        }

    }

    else {

        for( int i = 0; i < m_pRefSignature->numOfFlags(); ++i ) {

            if( ( pSig == 0 || ! (*pSig)[i] ) && (*m_pRefSignature)[i] ) {

                int j;



                for( j = 0; j < m_ForceExIndex.numOfElems(); ++j ) {

                    if( m_ForceExIndex[j] == i )

                        break;

                }

                if( j == m_ForceExIndex.numOfElems() )

                    forceExercise( UnderControl[i], i );

            }

        }

    }

}



MTG_END_NAMESPACE



//#define _TEST

#if defined(_TEST)



#include <conio.h>



MTG_USING_NAMESPACE





//

//   m a i n

//



void main( int argc, char *argv[] )



{

    bool bGo;

    int j, k, cCmd, nRet, nFlag, nBag;

    tSignature Sig;

    tSigBag SigBag;



    printf( "\nTest tSigBag\n\n" );



    Sig.reset( 8 );

    for( k = 0; k < Sig.numOfFlags(); ++k )

        Sig.on( k );



    SigBag.setRefSignature( &Sig );



    bGo = true;

    while( bGo ) {

        printf( "<R>reset <M>ayEx <F>orceEx <P>rint E<x>it: " );

        cCmd = getche();

        printf( "\n" );



        nRet = OK;

        switch( cCmd ) {

            case 'r' :

            case 'R' :

                SigBag.reset();

                break;



            case 'm' :

            case 'M' :

                printf( "  Bag Flag: " );

                scanf( "%d %d", &nBag, &nFlag );

                SigBag.mayExercise( nBag, nFlag );

                break;



            case 'f' :

            case 'F' :

                printf( "  Flag: " );

                scanf( "%d", &nFlag );

                SigBag.forceExercise( nFlag );

                break;



            case 'p' :

            case 'P' :

                printf( "  hasAlt = %d/%d/%d/%d\n",

                    SigBag.hasForceExAlternatives(),

                    SigBag.hasMayExAlternatives(),

                    SigBag.numOfAlternatives( 0 ),

                    SigBag.numOfAlternatives( 1 ) );

                for( j = -1; j < SigBag.numOfAlternatives( 0 ); ++j ) {

                    for( k = -1; k < SigBag.numOfAlternatives( 1 ); ++k ) {

                        tSigBag SB = SigBag;

                        SB.considerAlternative( j, k );

                        const tSignature& S = SB.altSignature();

                        printf( "  Alt(%d,%d) = ", j, k );

                        for( int i = 0; i < S.numOfFlags(); ++ i )

                            printf( "%d", S[i] );

                        printf( "," );

                        for( i = 0; i < SB.altNumOfExIndexes(); ++i )

                            printf( " %d", SB.altExIndex( i ) );

                        printf( "\n" );

                    }

                }

                break;



            case 'x' :

            case 'X' :

                bGo = false;

                break;

        }



        if( nRet != OK )

            printf( "  Error=%d\n", nRet );

    }

}



#endif

