// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgSignature.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tSignature::init( int nNumOfFlags )



{

    m_nNumOfFlags = nNumOfFlags;

    m_nSize = ( m_nNumOfFlags + 7 ) / 8;

    m_nTag = 0;



    if( m_nSize <= sizeof(m_aPreallocFlag) )

        m_aFlag = m_aPreallocFlag;

    else

        m_aFlag = new unsigned char[m_nSize];



    reset();

}





//

//   c l e a r

//



void tSignature::clear()



{

    if( m_nSize > sizeof(m_aPreallocFlag) && m_aFlag != 0 ) {

        delete[] m_aFlag;

        m_aFlag = 0;

    }

    m_nSize = 0;

    m_nNumOfFlags = 0;

}





//

//   t S i g n a t u r e

//



tSignature::tSignature( int nNumOfFlags )



{

    init( nNumOfFlags );

}





//

//   t S i g n a t u r e

//



tSignature::tSignature( const tSignature& Sig )



{

    init( Sig.m_nNumOfFlags );

    copyFrom( Sig );

}





//

//   ~ t S i g n a t u r e

//



tSignature::~tSignature()



{

    clear();

}





//

//   r e s e t

//



void tSignature::reset()



{

    for( size_t i = 0; i < m_nSize; ++i )

        m_aFlag[i] = 0;

    m_nTag = 0;

}





//

//   r e s e t

//



void tSignature::reset( int nNumOfFlags )



{

    if( nNumOfFlags == m_nNumOfFlags ) {

        reset();

    }

    else {

        clear();

        init( nNumOfFlags );

    }

}





//

//   o p e r a t o r =

//



tSignature& tSignature::operator=( const tSignature& Sig )



{

    if( &Sig != this )

        copyFrom( Sig );

    return *this;

}





//

//   c o p y F r o m

//



void tSignature::copyFrom( const tSignature& Sig )



{

    if( &Sig == this )

        return;



    if( Sig.m_nNumOfFlags != m_nNumOfFlags ) {

        clear();

        init( Sig.m_nNumOfFlags );

    }



    m_nTag = Sig.m_nTag;

    memcpy( m_aFlag, Sig.m_aFlag, m_nSize );

}





//

//   o p e r a t o r = =

//



bool tSignature::operator==( const tSignature& Sig ) const



{

    if( Sig.m_nNumOfFlags != m_nNumOfFlags )

        return false;

    if( memcmp( m_aFlag, Sig.m_aFlag, m_nSize ) != 0 )

        return false;

    return true;

}





//

//   o p e r a t o r & =

//



tSignature& tSignature::operator&=( const tSignature& Sig )



{

    MTG_ASSERT( Sig.m_nNumOfFlags == m_nNumOfFlags );



    for( size_t i = 0; i < m_nSize; ++i ) 

        m_aFlag[i] &= Sig.m_aFlag[i];

    return *this;

}





//

//   o p e r a t o r | =

//



tSignature& tSignature::operator|=( const tSignature& Sig )



{

    MTG_ASSERT( Sig.m_nNumOfFlags == m_nNumOfFlags );



    for( size_t i = 0; i < m_nSize; ++i ) 

        m_aFlag[i] |= Sig.m_aFlag[i];

    return *this;

}





//

//   o p e r a t o r ^ =

//



tSignature& tSignature::operator^=( const tSignature& Sig )



{

    MTG_ASSERT( Sig.m_nNumOfFlags == m_nNumOfFlags );

    for( size_t i = 0; i < m_nSize; ++i ) 

        m_aFlag[i] ^= Sig.m_aFlag[i];

    return *this;

}





//

//   c l o n e

//



tSignature* tSignature::clone() const



{

    return new tSignature( *this );

}





//

//   f l a g s O n

//



int tSignature::flagsOn() const



{

    int n = 0;

    for( int i = 0; i < m_nNumOfFlags; ++i ) {

        if( operator[]( i ) )

            ++n;

    }

    return n;

}



#if defined(_MTG_WITH_MATHLINK)



//

//   t o M a t h L i n k

//



tRetCode tSignature::toMathLink( MLINK MathLink ) const



{

    if( MLPutFunction( MathLink, "List", 2 ) == 0 ||

        MLPutInteger( MathLink, tag() ) == 0 ) {

        return MATHLINK_ERROR;

    }



    if( MLPutFunction( MathLink, "List", flagsOn() ) == 0 )

        return MATHLINK_ERROR;



        // In Mathematica, we count from 1, not from 0.



    for( int i = 0; i < numOfFlags(); ++i ) {

        if( operator[]( i ) ) {

            if( MLPutInteger( MathLink, i + 1 ) == 0 )

                return MATHLINK_ERROR;

        }

    }

    return OK;

}



#endif



MTG_END_NAMESPACE